/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.foundation.recipe;

import com.oierbravo.createmechanicalextruder.foundation.recipe.IRecipeWithRequirements;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirementType;
import com.oierbravo.createmechanicalextruder.foundation.utility.ModLang;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RecipeRequirementsBehaviour<R extends IRecipeWithRequirements>
extends BlockEntityBehaviour {
    public static final BehaviourType<RecipeRequirementsBehaviour<?>> TYPE = new BehaviourType();
    public RecipeRequirementsSpecifics<R> specifics;
    private boolean meetsRequirements;
    private boolean meetsIngredients;
    private boolean hasEnoughOutput;
    private ArrayList<String> missingRequirements;

    public <T extends SmartBlockEntity> RecipeRequirementsBehaviour(T te) {
        super(te);
        this.specifics = (RecipeRequirementsSpecifics)te;
        this.meetsIngredients = false;
        this.missingRequirements = new ArrayList();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean meetsRequirements() {
        return this.meetsRequirements;
    }

    public <T> boolean checkRequirements(Optional<R> pRecipe, Level pLevel, T pBlockEntity) {
        this.missingRequirements = new ArrayList();
        boolean result = true;
        if (pRecipe.isEmpty() || !this.specifics.matchIngredients((IRecipeWithRequirements)pRecipe.get())) {
            this.meetsIngredients = false;
            this.missingRequirements.add("ingredients");
            this.blockEntity.sendData();
            return false;
        }
        this.meetsIngredients = true;
        this.hasEnoughOutput = this.specifics.hasEnoughOutputSpace();
        if (!this.hasEnoughOutput) {
            this.missingRequirements.add("output");
            result = false;
        }
        this.meetsRequirements = this.checkRequirements((IRecipeWithRequirements)pRecipe.get(), pLevel, this.specifics);
        if (!this.meetsRequirements) {
            result = false;
        }
        this.blockEntity.sendData();
        return result;
    }

    private boolean checkRequirements(R pRecipe, Level pLevel, RecipeRequirementsSpecifics<R> pSpecifics) {
        boolean result = true;
        for (Map.Entry<RecipeRequirementType<?>, RecipeRequirement> entry : pRecipe.getRecipeRequirements().entrySet()) {
            if (this.checkRequirement(entry.getValue(), pLevel, (BlockEntity)pSpecifics)) continue;
            this.missingRequirements.add(entry.getKey().getId());
            result = false;
        }
        return result;
    }

    private boolean checkRequirement(RecipeRequirement value, Level pLevel, BlockEntity pSpecifics) {
        return value.test(pLevel, pSpecifics);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, boolean added) {
        if (this.missingRequirements.isEmpty()) {
            return false;
        }
        for (String requirementId : this.missingRequirements) {
            ModLang.translate("goggles.recipe_requirement." + requirementId, new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
            added = true;
        }
        return added;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        ListTag missingRequirementsTag = new ListTag();
        for (String missingId : this.missingRequirements) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("t", missingId);
            missingRequirementsTag.add((Object)tag);
        }
        compound.m_128365_("MissingRequirements", (Tag)missingRequirementsTag);
        super.write(compound, clientPacket);
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        this.missingRequirements = new ArrayList();
        ListTag missingRequirementsTag = compound.m_128437_("MissingRequirements", 10);
        for (Tag tag : missingRequirementsTag) {
            CompoundTag requirementsTag = (CompoundTag)tag;
            this.missingRequirements.add(requirementsTag.m_128461_("t"));
        }
        super.read(compound, clientPacket);
    }

    public static interface RecipeRequirementsSpecifics<R extends IRecipeWithRequirements> {
        public boolean hasEnoughOutputSpace();

        public boolean matchIngredients(R var1);
    }
}

