/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_chicken.foundation.blockEntity.behaviour;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class CycleBehavior
extends BlockEntityBehaviour {
    private final int CYCLE;
    private boolean ACTUATE_HALFCYCLE;
    public static final BehaviourType<CycleBehavior> TYPE = new BehaviourType();
    public CycleBehaviourSpecifics specifics;
    private int prevRunningTicks;
    private int runningTicks;
    private boolean running;
    private boolean finished;
    private int cycleDivider;

    public <T extends SmartBlockEntity> CycleBehavior(T te, int pCycle, boolean pActuateHalfCycle) {
        super(te);
        this.specifics = (CycleBehaviourSpecifics)te;
        this.CYCLE = pCycle;
        this.ACTUATE_HALFCYCLE = pActuateHalfCycle;
        this.cycleDivider = this.ACTUATE_HALFCYCLE ? 2 : 1;
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        this.finished = compound.m_128471_("Finished");
        this.prevRunningTicks = this.runningTicks = compound.m_128451_("Ticks");
        super.read(compound, clientPacket);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128379_("Finished", this.finished);
        compound.m_128405_("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
    }

    public void start() {
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.blockEntity.sendData();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        if (!this.running || level == null) {
            if (level != null && !level.f_46443_) {
                if (this.specifics.getKineticSpeed() == 0.0f) {
                    return;
                }
                if (this.specifics.tryProcess(true)) {
                    this.start();
                }
            }
            return;
        }
        if (level.f_46443_ && this.runningTicks == -this.CYCLE / this.cycleDivider) {
            this.prevRunningTicks = this.CYCLE / this.cycleDivider;
            return;
        }
        if (this.runningTicks == this.CYCLE / 2 && this.specifics.getKineticSpeed() != 0.0f) {
            this.apply();
            this.specifics.playSound();
            if (!level.f_46443_) {
                this.blockEntity.sendData();
            }
        }
        if (!level.f_46443_ && this.runningTicks > this.CYCLE / this.cycleDivider) {
            this.finished = true;
            this.running = false;
            this.blockEntity.sendData();
            this.specifics.onCycleCompleted();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < this.CYCLE / 2 && this.runningTicks >= this.CYCLE / this.cycleDivider) {
            this.runningTicks = this.CYCLE / 2;
            if (level.f_46443_ && !this.blockEntity.isVirtual()) {
                this.runningTicks = -(this.CYCLE / 2);
            }
        }
    }

    public float getProgress(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = Mth.m_14179_((float)partialTicks, (float)this.prevRunningTicks, (float)runningTicks);
        return ticks / (float)this.CYCLE * 100.0f;
    }

    protected void apply() {
        Level level = this.getWorld();
        if (level.f_46443_) {
            return;
        }
        if (this.specifics.tryProcess(false)) {
            this.blockEntity.sendData();
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.m_14179_((float)Mth.m_14036_((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getProgressPercent() {
        return Mth.m_14045_((int)(this.runningTicks * 100 / (this.CYCLE / this.cycleDivider)), (int)0, (int)100);
    }

    public static interface CycleBehaviourSpecifics {
        public void onCycleCompleted();

        public float getKineticSpeed();

        public boolean tryProcess(boolean var1);

        public void playSound();
    }
}

