/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.portable_stock_ticker;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.ClientScreenStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.stack.GenericStackSerializer;

public class GenericStackListPacket
extends SimplePacketBase {
    private final List<GenericStack> stacks;

    public GenericStackListPacket(List<GenericStack> stacks) {
        this.stacks = stacks;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.stacks.size());
        for (GenericStack stack : this.stacks) {
            GenericStackSerializer.write((GenericStack)stack, (FriendlyByteBuf)buffer);
        }
    }

    public static GenericStackListPacket read(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<GenericStack> list = new ArrayList<GenericStack>();
        for (int i = 0; i < size; ++i) {
            list.add(GenericStackSerializer.read((FriendlyByteBuf)buffer));
        }
        return new GenericStackListPacket(list);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(this::handleClient);
        context.setPacketHandled(true);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        ClientScreenStorage.stacks = this.stacks;
    }
}

