/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.FrameTrap;

import com.simibubi.create.content.contraptions.bearing.SailBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class FrameTrapBlock
extends SailBlock
implements ProperWaterloggedBlock,
IWrenchable {
    public FrameTrapBlock(BlockBehaviour.Properties properties) {
        super(properties, true, null);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.SOUTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult ourResult = this.handleFrameTrapInteraction(state, level, pos, player, hand, hitResult);
        if (ourResult != InteractionResult.PASS) {
            return ourResult;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    private InteractionResult handleFrameTrapInteraction(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof WrenchItem) {
            InteractionResult result;
            UseOnContext wrenchContext = new UseOnContext(level, player, hand, stack, hitResult);
            InteractionResult interactionResult = result = player.m_6144_() ? this.onSneakWrenched(state, wrenchContext) : this.onWrenched(state, wrenchContext);
            if (result != InteractionResult.PASS) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)f_52588_);
        VoxelShape frame = Shapes.m_83048_((double)0.0, (double)0.4375, (double)0.0, (double)1.0, (double)0.5625, (double)1.0);
        VoxelShape net = Shapes.m_83048_((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)0.4375, (double)0.875);
        VoxelShape baseShape = Shapes.m_83110_((VoxelShape)frame, (VoxelShape)net);
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> baseShape;
            case Direction.DOWN -> this.preciseRotateX(baseShape, 180);
            case Direction.NORTH -> this.preciseRotateX(baseShape, 90);
            case Direction.SOUTH -> this.preciseRotateX(baseShape, -90);
            case Direction.WEST -> this.preciseRotateZ(baseShape, 90);
            case Direction.EAST -> this.preciseRotateZ(baseShape, -90);
        };
    }

    private VoxelShape preciseRotateX(VoxelShape shape, int degrees) {
        List boxes = shape.m_83299_();
        VoxelShape[] result = new VoxelShape[]{Shapes.m_83040_()};
        double cos = Mth.m_14089_((float)((float)Math.toRadians(degrees)));
        double sin = Mth.m_14031_((float)((float)Math.toRadians(degrees)));
        boxes.forEach(box -> {
            AABB rotated = new AABB(this.preciseRound(box.f_82288_), this.preciseRound(cos * (box.f_82289_ - 0.5) - sin * (box.f_82290_ - 0.5) + 0.5), this.preciseRound(sin * (box.f_82289_ - 0.5) + cos * (box.f_82290_ - 0.5) + 0.5), this.preciseRound(box.f_82291_), this.preciseRound(cos * (box.f_82292_ - 0.5) - sin * (box.f_82293_ - 0.5) + 0.5), this.preciseRound(sin * (box.f_82292_ - 0.5) + cos * (box.f_82293_ - 0.5) + 0.5));
            result[0] = Shapes.m_83113_((VoxelShape)result[0], (VoxelShape)Shapes.m_83064_((AABB)rotated), (BooleanOp)BooleanOp.f_82695_);
        });
        return result[0];
    }

    private VoxelShape preciseRotateZ(VoxelShape shape, int degrees) {
        List boxes = shape.m_83299_();
        VoxelShape[] result = new VoxelShape[]{Shapes.m_83040_()};
        double cos = Mth.m_14089_((float)((float)Math.toRadians(degrees)));
        double sin = Mth.m_14031_((float)((float)Math.toRadians(degrees)));
        boxes.forEach(box -> {
            AABB rotated = new AABB(this.preciseRound(cos * (box.f_82288_ - 0.5) - sin * (box.f_82289_ - 0.5) + 0.5), this.preciseRound(sin * (box.f_82288_ - 0.5) + cos * (box.f_82289_ - 0.5) + 0.5), this.preciseRound(box.f_82290_), this.preciseRound(cos * (box.f_82291_ - 0.5) - sin * (box.f_82292_ - 0.5) + 0.5), this.preciseRound(sin * (box.f_82291_ - 0.5) + cos * (box.f_82292_ - 0.5) + 0.5), this.preciseRound(box.f_82293_));
            result[0] = Shapes.m_83113_((VoxelShape)result[0], (VoxelShape)Shapes.m_83064_((AABB)rotated), (BooleanOp)BooleanOp.f_82695_);
        });
        return result[0];
    }

    private double preciseRound(double value) {
        return (double)Math.round(value * 16.0) / 16.0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{WATERLOGGED}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        return this.withWater(stateForPlacement, context);
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return state;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.m_20162_()) {
            super.m_142072_(level, state, pos, entity, fallDistance);
        } else {
            entity.m_142535_(fallDistance, 0.0f, level.m_269111_().m_268989_());
        }
    }

    public void m_5548_(BlockGetter level, Entity entityIn) {
        if (entityIn.m_20162_()) {
            super.m_5548_(level, entityIn);
        } else {
            this.bounceEntity(entityIn);
        }
    }

    protected void bounceEntity(Entity entity) {
        Vec3 vec3d = entity.m_20184_();
        if (vec3d.f_82480_ < 0.0) {
            double entityWeightOffset = entity instanceof LivingEntity ? 0.6 : 0.8;
            entity.m_20334_(vec3d.f_82479_, -vec3d.f_82480_ * entityWeightOffset, vec3d.f_82481_);
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState rotated = this.getRotatedBlockState(state, context.m_43719_());
        if (!rotated.m_60710_((LevelReader)level, pos)) {
            return InteractionResult.PASS;
        }
        if (level.m_7731_(pos, rotated, 3)) {
            IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && !player.m_7500_()) {
            Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
        }
        state.m_222967_(serverLevel, pos, ItemStack.f_41583_, true);
        level.m_46961_(pos, false);
        IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        return Block.m_49931_((BlockState)newState, (LevelAccessor)context.m_43725_(), (BlockPos)context.m_8083_());
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (!originalState.m_61138_((Property)f_52588_)) {
            return originalState;
        }
        Direction currentFacing = (Direction)originalState.m_61143_((Property)f_52588_);
        if (currentFacing.m_122434_().equals((Object)targetedFace.m_122434_())) {
            return originalState;
        }
        Direction newFacing = currentFacing.m_175362_(targetedFace.m_122434_());
        return (BlockState)originalState.m_61124_((Property)f_52588_, (Comparable)newFacing);
    }
}

