/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.casting;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.CastingBlock;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.CastingBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.CastingFluidTank;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.table.CastingTableBlockEntity;
import fr.lucreeper74.createmetallurgy.utils.CastingItemRenderTypeBuffer;
import fr.lucreeper74.createmetallurgy.utils.ColoredFluidRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class CastingBlockRenderer
extends SmartBlockEntityRenderer<CastingBlockEntity> {
    public CastingBlockRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CastingBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        CastingFluidTank tank = be.inputTank;
        FluidStack fluidStack = tank.getFluid();
        float level = tank.getFluidLevel().getValue(partialTicks);
        int opacity = 0;
        int fluidOpacity = 255;
        if (!fluidStack.isEmpty() && level > 0.01f) {
            float yOffset;
            float min;
            if (be instanceof CastingTableBlockEntity) {
                min = 0.8125f;
                yOffset = 0.05f * level;
            } else {
                min = 0.125f;
                yOffset = 0.8125f * level;
            }
            ms.m_85836_();
            ms.m_252880_(0.0f, yOffset, 0.0f);
            if (be.running) {
                int timer = be.processingTick;
                int totalTime = be.totalProcessTicks;
                if (timer > 0 && totalTime > 0) {
                    opacity = 1020 * (totalTime - timer) / totalTime;
                }
                if (opacity > 765) {
                    fluidOpacity = 1020 - opacity;
                }
            }
            ColoredFluidRenderer.renderFluidBox(fluidStack, 0.125f, min - yOffset, 0.125f, 0.875f, min, 0.875f, buffer, ms, light, ColoredFluidRenderer.RGBAtoColor(255, 255, 255, fluidOpacity), false);
            ms.m_85849_();
        }
        if (be.running) {
            CastingItemRenderTypeBuffer bufferOut = new CastingItemRenderTypeBuffer(buffer, opacity / 4, fluidOpacity);
            this.renderItem(be, ms, bufferOut, light, overlay, be.getRecipeOutput());
        }
        this.renderItem(be, ms, buffer, light, overlay, be.inv.m_8020_(0));
        this.renderItem(be, ms, buffer, light, overlay, be.moldInv.m_8020_(0));
    }

    protected void renderItem(CastingBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ms.m_85836_();
        if (be instanceof CastingTableBlockEntity) {
            ms.m_252880_(0.5f, 0.0f, 0.5f);
            ms.m_252781_(Axis.f_252436_.m_252977_(-90.0f * (float)((Direction)be.m_58900_().m_61143_((Property)CastingBlock.FACING)).m_122416_()));
            ms.m_252880_(-0.5f, 0.0f, -0.5f);
            ms.m_252880_(0.5f, 0.84375f, 0.6875f);
            ms.m_85841_(1.5f, 1.5f, 1.5f);
            ms.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        } else if (stack.m_41720_() instanceof BlockItem) {
            ms.m_252880_(0.5f, 0.0f, 0.5f);
            ms.m_85841_(3.1f, 3.1f, 3.1f);
        } else {
            ms.m_252880_(0.5f, 0.5f, 0.5f);
            ms.m_85841_(1.0f, 1.0f, 1.0f);
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, (Level)mc.f_91073_, 0);
        ms.m_85849_();
    }
}

