/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingBasinRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingOutput;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingTableRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public abstract class CastingRecipeSerializer
implements RecipeSerializer<CastingRecipe> {
    protected void writeToJson(JsonObject json, CastingRecipe recipe) {
        FluidIngredient fluidIngredient;
        JsonArray jsonIngredients = new JsonArray();
        Ingredient ingredient = recipe.ingredient;
        if (!ingredient.m_43947_()) {
            jsonIngredients.add(ingredient.m_43942_());
        }
        if ((fluidIngredient = recipe.fluidIngredient) != FluidIngredient.EMPTY) {
            jsonIngredients.add((JsonElement)recipe.fluidIngredient.serialize());
        }
        json.add("ingredients", (JsonElement)jsonIngredients);
        json.add("result", recipe.result.serialize());
        int processingDuration = recipe.getProcessingDuration();
        if (processingDuration > 0) {
            json.addProperty("processingTime", (Number)processingDuration);
        }
        if (recipe.moldConsumed) {
            json.addProperty("mold_consumed", Boolean.valueOf(true));
        }
    }

    public CastingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        CastingRecipe recipe = this.createRecipe(recipeId);
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
            if (FluidIngredient.isFluidIngredient((JsonElement)je)) {
                recipe.fluidIngredient = FluidIngredient.deserialize((JsonElement)je);
                continue;
            }
            recipe.ingredient = Ingredient.m_43917_((JsonElement)je);
        }
        recipe.processingDuration = GsonHelper.m_13927_((JsonObject)json, (String)"processingTime");
        recipe.moldConsumed = GsonHelper.m_13855_((JsonObject)json, (String)"mold_consumed", (boolean)false);
        JsonObject je = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        if (je.isJsonObject() && !GsonHelper.m_13900_((JsonObject)je.getAsJsonObject(), (String)"fluid")) {
            recipe.result = CastingOutput.deserialize((JsonElement)je);
        }
        return recipe;
    }

    @Nullable
    public CastingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        CastingRecipe recipe = this.createRecipe(recipeId);
        recipe.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        recipe.fluidIngredient = FluidIngredient.read((FriendlyByteBuf)buffer);
        recipe.processingDuration = buffer.readInt();
        recipe.moldConsumed = buffer.readBoolean();
        recipe.result = CastingOutput.read(buffer);
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf buffer, CastingRecipe recipe) {
        recipe.ingredient.m_43923_(buffer);
        recipe.fluidIngredient.write(buffer);
        buffer.writeInt(recipe.processingDuration);
        buffer.writeBoolean(recipe.moldConsumed);
        recipe.result.write(buffer);
    }

    public final void write(JsonObject json, CastingRecipe recipe) {
        this.writeToJson(json, recipe);
    }

    public abstract CastingRecipe createRecipe(ResourceLocation var1);

    public static class CastingBasinRecipeSerializer
    extends CastingRecipeSerializer {
        @Override
        public CastingRecipe createRecipe(ResourceLocation id) {
            return new CastingBasinRecipe(id);
        }
    }

    public static class CastingTableRecipeSerializer
    extends CastingRecipeSerializer {
        @Override
        public CastingRecipe createRecipe(ResourceLocation id) {
            return new CastingTableRecipe(id);
        }
    }
}

