/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.items;

import com.razz.decocraft.common.blocks.DecocraftBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DecoBlockItem
extends BlockItem {
    private static final float CRAFTING_SCALE = 32.0f;
    private boolean above_water;
    private int material = -1;
    private int red = -1;
    private int green = -1;
    private int blue = -1;

    public DecoBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
        DecocraftBlock decoblock = (DecocraftBlock)block;
        this.above_water = decoblock.meta.above_water;
        if (decoblock.meta.crafting_color[0] >= 0.0f && decoblock.meta.crafting_color[1] >= 0.0f && decoblock.meta.crafting_color[2] >= 0.0f) {
            this.red = Math.round(decoblock.meta.crafting_color[0] / 100.0f * 32.0f);
            this.green = Math.round(decoblock.meta.crafting_color[1] / 100.0f * 32.0f);
            this.blue = Math.round(decoblock.meta.crafting_color[2] / 100.0f * 32.0f);
        }
        try {
            AABB bounds = decoblock.getShape()[0].m_83215_();
            this.material = Math.min(Math.max((int)Math.ceil((bounds.f_82291_ - bounds.f_82288_) * (bounds.f_82292_ - bounds.f_82289_) * (bounds.f_82293_ - bounds.f_82290_)), 1), 10);
        }
        catch (UnsupportedOperationException e) {
            System.out.println(String.format("%s %s", new Object[]{e, decoblock}));
            this.material = 1;
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getMaterial() {
        return this.material;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (this.above_water) {
            BlockHitResult blockHitResult;
            BlockPos pos;
            ItemStack itemStack = player.m_21120_(hand);
            BlockHitResult hitResult = DecoBlockItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (hitResult.m_6662_() == HitResult.Type.MISS) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            if (hitResult.m_6662_() == HitResult.Type.BLOCK && (level.m_8055_(pos = (blockHitResult = hitResult).m_82425_()).m_60713_(Blocks.f_49990_) || level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_))) {
                BlockPlaceContext placementContext;
                InteractionResult result;
                BlockPos surfacePos = pos;
                while (level.m_8055_(surfacePos.m_7494_()).m_60713_(Blocks.f_49990_)) {
                    surfacePos = surfacePos.m_7494_();
                }
                BlockPos placePos = surfacePos.m_7494_();
                if ((level.m_8055_(placePos).m_60795_() || level.m_8055_(placePos).m_247087_()) && (result = this.m_40576_(placementContext = new BlockPlaceContext(player, hand, itemStack, new BlockHitResult(Vec3.m_82512_((Vec3i)placePos), Direction.UP, placePos, false)))).m_19077_()) {
                    return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
                }
            }
        }
        return super.m_7203_(level, player, hand);
    }
}

