/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public abstract class DLAbstractImageButton<T extends DLAbstractImageButton<T>>
extends DLButton {
    private boolean selected = false;
    private final WidgetsCollection collection;
    private ButtonType type;
    private DynamicGuiRenderer.AreaStyle style;
    private EAlignment alignment = EAlignment.CENTER;

    public DLAbstractImageButton(ButtonType type, DynamicGuiRenderer.AreaStyle style, int x, int y, int w, int h, Component pMessage, Consumer<T> onClick) {
        this(type, style, null, x, y, w, h, pMessage, onClick);
    }

    public DLAbstractImageButton(ButtonType type, DynamicGuiRenderer.AreaStyle style, WidgetsCollection collection, int pX, int pY, int w, int h, Component pMessage, Consumer<T> onClick) {
        super(pX, pY, w, h, pMessage, onClick);
        this.withButtonType(type);
        this.withStyle(style);
        if (collection != null) {
            collection.components.add((AbstractWidget)this);
        }
        this.collection = collection;
        this.setTextShadow(false);
    }

    @Override
    public void setTextAlignment(EAlignment alignment) {
        super.setTextAlignment(alignment);
        this.withAlignment(alignment);
    }

    public ButtonType getButtonType() {
        return this.type;
    }

    public EAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    public DynamicGuiRenderer.AreaStyle getStyle() {
        return this.style;
    }

    public T withAlignment(EAlignment alignment) {
        this.alignment = alignment;
        return (T)this;
    }

    public T withStyle(DynamicGuiRenderer.AreaStyle style) {
        this.style = style;
        return (T)this;
    }

    public T withButtonType(ButtonType type) {
        this.type = type;
        return (T)this;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void deselect() {
        this.selected = false;
    }

    public void select() {
        this.selected = true;
    }

    public void toggleSelection() {
        this.selected = !this.selected;
    }

    public void m_5691_() {
        switch (this.type.ordinal()) {
            case 1: {
                if (this.selected) {
                    return;
                }
                this.selected = true;
                if (this.collection == null) break;
                this.collection.performForEach(x -> x instanceof DLAbstractImageButton && x != this, x -> ((DLAbstractImageButton)x).deselect());
                break;
            }
            case 2: {
                this.toggleSelection();
                break;
            }
        }
        super.m_5691_();
    }

    @Override
    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        DynamicGuiRenderer.renderArea(graphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.getBackColor(), this.style, this.m_142518_() ? (this.isSelected() ? DynamicGuiRenderer.ButtonState.DOWN : (this.isMouseSelected() ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON)) : DynamicGuiRenderer.ButtonState.DISABLED);
        GuiUtils.resetTint();
        this.renderImage(graphics, pMouseX, pMouseY, pPartialTick);
        GuiUtils.resetTint();
    }

    public abstract void renderImage(Graphics var1, int var2, int var3, float var4);

    public static enum ButtonType {
        DEFAULT,
        RADIO_BUTTON,
        TOGGLE_BUTTON;

    }
}

