/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.world.phys.Vec2;

public class DLContextMenu
extends DLWidgetContainer {
    private final Supplier<DLContextMenuItem.Builder> openAction;
    private final Supplier<GuiAreaDefinition> area;
    private DLContextMenu parent;

    public DLContextMenu(Supplier<GuiAreaDefinition> area, Supplier<DLContextMenuItem.Builder> openAction) {
        super(0, 0, 100, 100);
        this.area = area;
        this.openAction = openAction;
        this.visible = false;
    }

    public void setParentMenu(DLContextMenu parent) {
        this.parent = parent;
    }

    public DLContextMenu getParent() {
        return this.parent;
    }

    @Override
    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        this.setHovered(mouseX, mouseY);
        GuiUtils.drawBox(graphics, new GuiAreaDefinition(this.x, this.y, this.width, this.height), -16777216, -6381922);
        GuiUtils.fill(graphics, this.x + 1, this.y + this.height, this.width, 1, -132112352);
        GuiUtils.fill(graphics, this.x + this.width, this.y + 1, 1, this.height, -132112352);
        for (Object e : this.renderables) {
            if (!(e instanceof DLContextMenuItem)) continue;
            DLContextMenuItem item = (DLContextMenuItem)e;
            item.m_88315_(graphics.graphics(), mouseX, mouseY, partialTicks);
            item.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public int getAreaX() {
        return this.getX() + 1;
    }

    public int getAreaWidth() {
        return this.getWidth() - 2;
    }

    public int getAreaY() {
        return this.getY() + 3;
    }

    public int getAreaHeight() {
        return this.getHeight() - 6;
    }

    public void setSize(int areaW, int areaH) {
        this.setWidth(areaW + 2);
        this.setHeight(areaH + 6);
    }

    protected void addItem(DLContextMenuItem item) {
        this.addRenderableWidget(item);
    }

    public boolean open(int mouseX, int mouseY) {
        return this.open(mouseX, mouseY, mouseX, mouseY);
    }

    public boolean open(int mouseX, int mouseY, int x, int y) {
        return this.open(mouseX, mouseY, menu -> new Vec2((float)x, (float)y));
    }

    @Override
    public boolean isHovered() {
        return super.isHovered() || this.m_6702_().stream().anyMatch(x -> {
            DLContextMenuItem item;
            return x instanceof DLContextMenuItem && (item = (DLContextMenuItem)x).getContextMenu() != null && item.getContextMenu().isHovered();
        });
    }

    public boolean isOpen() {
        return this.visible();
    }

    public boolean open(int mouseX, int mouseY, Function<DLContextMenu, Vec2> pos) {
        if (this.area.get() != null && !this.area.get().isInBounds(mouseX, mouseY) || Minecraft.m_91087_().f_91080_ == null) {
            return false;
        }
        this.openAction.get().applySize(this);
        Vec2 p = pos.apply(this);
        this.setX(Math.min((int)p.f_82470_, Minecraft.m_91087_().f_91080_.f_96543_ - this.getWidth()));
        this.setY(Math.min((int)p.f_82471_, Minecraft.m_91087_().f_91080_.f_96544_ - this.getHeight()));
        this.clearWidgets();
        this.openAction.get().build(this).forEach(a -> this.addItem((DLContextMenuItem)a));
        this.set_visible(true);
        return true;
    }

    @Override
    public void close() {
        this.clearWidgets();
        this.set_visible(false);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean b = super.m_6375_(mouseX, mouseY, button);
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            IDragonLibWidget widget;
            DLContextMenu menu;
            if (!(guiEventListener instanceof IDragonLibWidget) || (menu = (widget = (IDragonLibWidget)guiEventListener).getContextMenu()) == null) continue;
            if (!b && widget.contextMenuMouseClickHandler((int)mouseX, (int)mouseY, button, 0, 0, null)) {
                this.m_6702_().stream().filter(x -> {
                    if (!(x instanceof IDragonLibWidget)) return false;
                    IDragonLibWidget w = (IDragonLibWidget)x;
                    if (x == widget) return false;
                    if (w.getContextMenu() == null) return false;
                    return true;
                }).forEach(x -> {
                    DLContextMenu men = ((IDragonLibWidget)x).getContextMenu();
                    men.close();
                });
                if (this.parent != null) {
                    this.parent.close();
                }
                return true;
            }
            if (menu.isHovered()) continue;
            menu.close();
        }
        if (b) {
            this.close();
            if (this.getParent() != null) {
                this.getParent().close();
            }
        }
        return b;
    }

    @Override
    public boolean consumeScrolling(double mouseX, double mouseY) {
        return true;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public int getAllowedLayer() {
        return 0;
    }

    @Override
    public void setAllowedLayer(int index) {
    }

    @Override
    public void setWidgetLayerIndex(int layerIndex) {
    }

    @Override
    public int getWidgetLayerIndex() {
        return 0;
    }
}

