/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class DLWidgetsCollection {
    public final List<IDragonLibWidget> components = new ArrayList<IDragonLibWidget>();
    private boolean enabled = true;
    private boolean visible = true;

    public void performForEach(Predicate<? super IDragonLibWidget> filter, Consumer<? super IDragonLibWidget> consumer) {
        this.components.stream().filter(filter).forEach(consumer);
    }

    public void performForEach(Consumer<? super IDragonLibWidget> consumer) {
        this.performForEach(x -> true, consumer);
    }

    public <C extends IDragonLibWidget> void performForEachOfType(Class<C> clazz, Predicate<C> filter, Consumer<C> consumer) {
        this.components.stream().filter(clazz::isInstance).map(clazz::cast).filter(filter).forEach(consumer);
    }

    public <C extends IDragonLibWidget> void performForEachOfType(Class<C> clazz, Consumer<C> consumer) {
        this.performForEachOfType(clazz, x -> true, consumer);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean v) {
        this.visible = v;
        this.performForEach(x -> x.set_visible(v));
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
        this.performForEach(x -> x.set_active(e));
    }

    public <W extends IDragonLibWidget> void add(W widget) {
        widget.set_active(this.enabled);
        widget.set_visible(this.visible);
        this.components.add(widget);
    }

    public void clear() {
        this.components.clear();
    }

    public void clear(Consumer<IDragonLibWidget> onRemove) {
        this.performForEach(x -> onRemove.accept((IDragonLibWidget)x));
        this.clear();
    }
}

