/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public final class MathUtils {
    public static final Vec3 CENTER_OF_ORIGIN = new Vec3(0.5, 0.5, 0.5);

    public static double round(double value, int decimals) {
        if (decimals < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, decimals);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static Vec3i blockPosToVec3i(BlockPos pos) {
        return new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static Vec3 blockPosToVec3(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static double slope(Vec3 a, Vec3 b) {
        double heightDiff = Math.max(a.f_82480_, b.f_82480_) - Math.min(a.f_82480_, b.f_82480_);
        Vec3 vec = b.m_82546_(a);
        double distance = vec.m_165924_();
        return distance / heightDiff;
    }

    public static double lerp(double pDelta, double pStart, double pEnd) {
        return pStart + pDelta * (pEnd - pStart);
    }

    public static byte clamp(byte pValue, byte pMin, byte pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static int clamp(int pValue, int pMin, int pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static long clamp(long pValue, long pMin, long pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static float clamp(float pValue, float pMin, float pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static double clamp(double pValue, double pMin, double pMax) {
        if (pValue < pMin) {
            return pMin;
        }
        return pValue > pMax ? pMax : pValue;
    }

    public static double getVectorAngle(Vec3 vec) {
        return Math.round(Math.atan2(vec.m_7096_(), -vec.m_7094_()) * 57.29577951308232);
    }

    private static double calcScale(double minScale, double maxScale, double maxWidth, double fontWidth) {
        double scale = Math.min(maxWidth / fontWidth, 1.0);
        return Math.max(maxScale * scale, minScale);
    }

    public static double getScale(float fontWidth, float lineWidth, float min, float max) {
        return MathUtils.calcScale(min, max, lineWidth / max, fontWidth);
    }

    public static double calculateMedian(Queue<Double> database, double smoothingThreshold, Predicate<Double> filter) {
        if (database.isEmpty()) {
            return 0.0;
        }
        LinkedList<Double> values = new LinkedList<Double>();
        Iterator iterator = database.iterator();
        while (iterator.hasNext()) {
            double i = (Double)iterator.next();
            if (!filter.test(i)) continue;
            values.add(i);
        }
        Collections.sort(values);
        double median = 0.0;
        if (values.size() % 2 == 0) {
            median = ((Double)values.get(values.size() / 2) + (Double)values.get(values.size() / 2 + 1)) / 2.0;
        }
        double med = median = ((Double)values.get(values.size() / 2)).doubleValue();
        return database.stream().mapToDouble(x -> x).filter(x -> Math.abs(med - x) <= smoothingThreshold).average().orElse(0.0);
    }

    public static Vec3 rotate(Vec3 vec, Vec3 rotationVec) {
        return MathUtils.rotate(vec, rotationVec.f_82479_, rotationVec.f_82480_, rotationVec.f_82481_);
    }

    public static Vec3 rotate(Vec3 vec, double xRot, double yRot, double zRot) {
        return MathUtils.rotate(MathUtils.rotate(MathUtils.rotate(vec, xRot, Direction.Axis.X), yRot, Direction.Axis.Y), zRot, Direction.Axis.Z);
    }

    public static Vec3 rotateCentered(Vec3 vec, double deg, Direction.Axis axis) {
        Vec3 shift = MathUtils.getCenterOf((Vec3i)BlockPos.f_121853_);
        return MathUtils.rotate(vec.m_82546_(shift), deg, axis).m_82549_(shift);
    }

    public static Vec3 rotate(Vec3 vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec3.f_82478_) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double x = vec.f_82479_;
        double y = vec.f_82480_;
        double z = vec.f_82481_;
        if (axis == Direction.Axis.X) {
            return new Vec3(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static Vec3 getCenterOf(Vec3i pos) {
        if (pos.equals((Object)Vec3i.f_123288_)) {
            return CENTER_OF_ORIGIN;
        }
        return Vec3.m_82528_((Vec3i)pos).m_82520_(0.5, 0.5, 0.5);
    }
}

