/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.accessor;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.mcdragonlib.util.accessor.BasicDataAccessorPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class DataAccessorType<I, C, O> {
    private static final Map<ResourceLocation, DataAccessorType<?, ?, ?>> values = new HashMap();
    public static final String DEFAULT_NBT_DATA = "Data";
    private ResourceLocation id;
    public final BiConsumer<I, CompoundTag> encodeRequest;
    public final Function<CompoundTag, I> decodeRequest;
    public final BasicDataAccessorPacket.IServerProcessor<I> serverProcessor;
    public final BasicDataAccessorPacket.IChunkReceiver<C> chunkProcessor;
    public final Function<C, O> output;

    public DataAccessorType(BiConsumer<I, CompoundTag> encodeRequest, Function<CompoundTag, I> decodeRequest, BasicDataAccessorPacket.IServerProcessor<I> serverProcessor, BasicDataAccessorPacket.IChunkReceiver<C> chunkProcessor, Function<C, O> output) {
        this.encodeRequest = encodeRequest;
        this.decodeRequest = decodeRequest;
        this.serverProcessor = serverProcessor;
        this.chunkProcessor = chunkProcessor;
        this.output = output;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static <I, C, O> DataAccessorType<I, C, O> register(ResourceLocation id, DataAccessorType<I, C, O> o) {
        if (values.containsKey(id)) {
            throw new IllegalArgumentException("A DataAccessorType with this id already exists: " + String.valueOf(id));
        }
        values.put(id, o);
        o.id = id;
        return o;
    }

    public static ImmutableList<DataAccessorType<?, ?, ?>> values() {
        return ImmutableList.copyOf(values.values());
    }

    public static <I, C, O> Optional<DataAccessorType<I, C, O>> get(ResourceLocation id) {
        return Optional.ofNullable(values.containsKey(id) ? values.get(id) : null);
    }

    public static class Builder {
        public static <I, C, O> DataAccessorType<I, C, O> createChunked(BiConsumer<I, CompoundTag> encodeRequest, Function<CompoundTag, I> decodeRequest, BasicDataAccessorPacket.IServerProcessor<I> serverProcessor, BasicDataAccessorPacket.IChunkReceiver<C> chunkProcessor, Function<C, O> output) {
            return new DataAccessorType<I, C, O>(encodeRequest, decodeRequest, serverProcessor, chunkProcessor, output);
        }

        public static <I, O> DataAccessorType<I, O, O> create(BiConsumer<I, CompoundTag> encodeRequest, Function<CompoundTag, I> decodeRequest, BasicDataAccessorPacket.IServerProcessor<I> serverProcessor, BasicDataAccessorPacket.IChunkReceiver<O> chunkProcessor) {
            return Builder.createChunked(encodeRequest, decodeRequest, serverProcessor, chunkProcessor, x -> x);
        }

        public static <I> DataAccessorType<I, Void, Void> createEmptyResponse(BiConsumer<I, CompoundTag> encodeRequest, Function<CompoundTag, I> decodeRequest, BasicDataAccessorPacket.IServerProcessor<I> serverProcessor) {
            return new DataAccessorType<I, Void, Void>(encodeRequest, decodeRequest, serverProcessor, (a, b, c, d) -> null, x -> x);
        }

        public static <C, O> DataAccessorType<Void, C, O> createNoInputChunked(BasicDataAccessorPacket.IServerProcessor<Void> serverProcessor, BasicDataAccessorPacket.IChunkReceiver<C> chunkProcessor, Function<C, O> output) {
            return new DataAccessorType<Void, C, O>((i, nbt) -> {}, nbt -> null, serverProcessor, chunkProcessor, output);
        }

        public static <O> DataAccessorType<Void, O, O> createNoInput(BasicDataAccessorPacket.IServerProcessor<Void> serverProcessor, BasicDataAccessorPacket.IChunkReceiver<O> chunkProcessor) {
            return Builder.createNoInputChunked(serverProcessor, chunkProcessor, x -> x);
        }

        public static DataAccessorType<Void, Void, Void> createNoIO(BasicDataAccessorPacket.IServerProcessor<Void> serverProcessor) {
            return Builder.createNoInput(serverProcessor, (a, b, c, d) -> null);
        }
    }
}

