/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.model;

import de.markusbordihn.easymobfarm.client.model.ModelManagerInterface;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static ModelManagerInterface modelManager;

    private ModelManager() {
    }

    public static void registerModelManager(ModelManagerInterface modelManagerInterface) {
        log.info("{} Model Manager {}", (Object)"Register Easy Mob Farm", (Object)modelManagerInterface.getClass().getName());
        modelManager = modelManagerInterface;
    }

    public static ModelManagerInterface getModelManager() {
        return modelManager;
    }

    public static BakedModel getModel(MobCaptureData mobCaptureData, BakedModel originalModel) {
        if (mobCaptureData == null || mobCaptureData.type() == null || mobCaptureData.type().isEmpty() || modelManager == null) {
            return originalModel;
        }
        BakedModel bakedModel = mobCaptureData.hasColor() || mobCaptureData.hasVariant() ? modelManager.getModel(mobCaptureData.type(), mobCaptureData.variant(), mobCaptureData.color()) : modelManager.getModel(mobCaptureData.type());
        if (bakedModel != null) {
            return bakedModel;
        }
        if (mobCaptureData.hasRarity() && (bakedModel = modelManager.getModel(mobCaptureData.rarity())) != null) {
            return bakedModel;
        }
        bakedModel = modelManager.getModel(mobCaptureData.entityType());
        if (bakedModel != null) {
            return bakedModel;
        }
        if (originalModel != null && originalModel != Minecraft.m_91087_().m_91304_().m_119409_() && originalModel.m_6160_() != Minecraft.m_91087_().m_91304_().m_119409_().m_6160_()) {
            return originalModel;
        }
        return modelManager.getDefaultModel();
    }

    public static ModelResourceLocation getRegistrationModelResourceLocation(ModelResourceLocation modelResourceLocation) {
        return new ModelResourceLocation(new ResourceLocation(modelResourceLocation.m_135827_(), modelResourceLocation.m_135815_().replace("item/", "")), modelResourceLocation.m_119448_());
    }
}

