/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.data.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.data.RecipeException;
import net.permutated.exmachinis.data.builders.AbstractRecipeBuilder;
import net.permutated.exmachinis.util.IngredientStack;
import net.permutated.exmachinis.util.SerializerUtil;

public class CompactingRecipeBuilder
extends AbstractRecipeBuilder {
    private IngredientStack ingredient = new IngredientStack(Ingredient.f_43901_, 0);
    private final ItemStack output;

    @Override
    protected String getPrefix() {
        return "compacting";
    }

    public CompactingRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public static CompactingRecipeBuilder builder(Item output, int count) {
        return new CompactingRecipeBuilder(new ItemStack((ItemLike)output, count));
    }

    public static CompactingRecipeBuilder builder(Item output) {
        return new CompactingRecipeBuilder(new ItemStack((ItemLike)output));
    }

    public CompactingRecipeBuilder setInput(Ingredient input, int count) {
        this.ingredient = new IngredientStack(input, count);
        return this;
    }

    public CompactingRecipeBuilder setInput(ItemLike input, int count) {
        return this.setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), count);
    }

    public CompactingRecipeBuilder setInput(TagKey<Item> input, int count) {
        return this.setInput(Ingredient.m_204132_(input), count);
    }

    @Override
    protected void validate(ResourceLocation id) {
        if (Ingredient.f_43901_.equals(this.ingredient.ingredient())) {
            throw new RecipeException(id.toString(), "input is required");
        }
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        String path = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_())).m_135815_();
        this.build(consumer, this.id(path));
    }

    @Override
    protected AbstractRecipeBuilder.AbstractResult getResult(ResourceLocation id) {
        return new Result(id);
    }

    public class Result
    extends AbstractRecipeBuilder.AbstractResult {
        public Result(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(JsonObject jsonObject) {
            jsonObject.add("input", (JsonElement)CompactingRecipeBuilder.this.ingredient.toJson());
            jsonObject.add("output", SerializerUtil.serializeItemStack(CompactingRecipeBuilder.this.output));
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRegistry.COMPACTING_RECIPE_SERIALIZER.get();
        }
    }
}

