/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.crafttweaker.handler;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.MeltingRecipe;
import novamachina.exnihilosequentia.world.level.block.entity.CrucibleBlockEntity;

@IRecipeHandler.For(value=MeltingRecipe.class)
public class MeltingRecipeHandler
implements IRecipeHandler<MeltingRecipe> {
    public String dumpToCommandString(IRecipeManager<? super MeltingRecipe> manager, MeltingRecipe recipe) {
        return String.format("<recipetype:exnihilosequentia:compost>.addRecipe(%s, %s, %s, %s);", StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), IIngredient.fromIngredient((Ingredient)recipe.getInput()).getCommandString(), IFluidStack.of((Object)recipe.getResultFluid()).getCommandString(), String.format("CrucibleType.%s()", recipe.getCrucibleType().getName()));
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super MeltingRecipe> manager, MeltingRecipe firstRecipe, U secondRecipe) {
        MeltingRecipe second = (MeltingRecipe)secondRecipe;
        return IngredientUtil.canConflict((Ingredient)firstRecipe.getInput(), (Ingredient)second.getInput());
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super MeltingRecipe> manager, MeltingRecipe recipe) {
        IIngredient input = IIngredient.fromIngredient((Ingredient)recipe.getInput());
        IFluidStack fluidStack = IFluidStack.of((Object)recipe.getResultFluid());
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, (Object)input).with(BuiltinRecipeComponents.Output.FLUIDS, (Object)fluidStack).with(BuiltinRecipeComponents.Metadata.GROUP, (Object)recipe.getCrucibleType().getName()).build();
        return Optional.of(decomposition);
    }

    public Optional<MeltingRecipe> recompose(IRecipeManager<? super MeltingRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        IIngredient input = (IIngredient)recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS);
        IFluidStack fluidStack = (IFluidStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.FLUIDS);
        CrucibleBlockEntity.CrucibleType type = CrucibleBlockEntity.CrucibleType.getTypeByName((String)recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP));
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Invalid input: empty ingredient");
        }
        if (fluidStack.isEmpty()) {
            throw new IllegalArgumentException("Invalid fluid: empty fluid");
        }
        if (type == null) {
            throw new IllegalArgumentException("Invalid type: missing type");
        }
        return Optional.of(new MeltingRecipe(name, input.asVanillaIngredient(), (FluidStack)fluidStack.getInternal(), type));
    }
}

