/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.crafttweaker.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import novamachina.exnihilosequentia.world.item.crafting.MeshWithChance;
import novamachina.exnihilosequentia.world.item.crafting.SiftingRecipe;

@IRecipeHandler.For(value=SiftingRecipe.class)
public class SiftingRecipeHandler
implements IRecipeHandler<SiftingRecipe> {
    IRecipeComponent<List<MeshWithChance>> MESH_WITH_CHANCE = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "output/mesh_with_chance"), (TypeToken)new TypeToken<List<MeshWithChance>>(){}, List::equals);
    IRecipeComponent<Boolean> BOOL = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "bool"), (TypeToken)new TypeToken<Boolean>(){}, (aBoolean, aBoolean2) -> aBoolean == aBoolean2);

    public String dumpToCommandString(IRecipeManager<? super SiftingRecipe> manager, SiftingRecipe recipe) {
        StringJoiner rollJoiner = new StringJoiner(", ");
        for (MeshWithChance roll : recipe.getRolls()) {
            rollJoiner.add(String.format("MeshWithChance.of(%s, %f)", String.format("MeshType.%s()", roll.getMesh().getMeshName()), Float.valueOf(roll.getChance())));
        }
        return String.format("<recipetype:exnihilosequentia:sifting>.addRecipe(%s, %s, %s, %b, [%s]);", StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), IIngredient.fromIngredient((Ingredient)recipe.getInput()).getCommandString(), IItemStack.of((ItemStack)recipe.getDrop()).getCommandString(), recipe.isWaterlogged(), rollJoiner);
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super SiftingRecipe> manager, SiftingRecipe firstRecipe, U secondRecipe) {
        SiftingRecipe second = (SiftingRecipe)secondRecipe;
        return IngredientUtil.canConflict((Ingredient)firstRecipe.getInput(), (Ingredient)second.getInput()) && firstRecipe.isWaterlogged() == second.isWaterlogged();
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super SiftingRecipe> manager, SiftingRecipe recipe) {
        IIngredient input = IIngredient.fromIngredient((Ingredient)recipe.getInput());
        IItemStack drop = IItemStack.of((ItemStack)recipe.getDrop());
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, (Object)input).with(BuiltinRecipeComponents.Output.ITEMS, (Object)drop).with(this.BOOL, (Object)recipe.isWaterlogged()).with(this.MESH_WITH_CHANCE, recipe.getRolls()).build();
        return Optional.of(decomposition);
    }

    public Optional<SiftingRecipe> recompose(IRecipeManager<? super SiftingRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        IIngredient input = (IIngredient)recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack drop = (IItemStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        boolean isWaterlogged = (Boolean)recipe.getOrThrowSingle(this.BOOL);
        List rolls = (List)recipe.getOrThrowSingle(this.MESH_WITH_CHANCE);
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Invalid input: empty ingredient");
        }
        if (drop.isEmpty()) {
            throw new IllegalArgumentException("Invalid drop: empty item stack");
        }
        if (rolls.isEmpty()) {
            throw new IllegalArgumentException("Invalid roll list: empty list");
        }
        return Optional.of(new SiftingRecipe(name, input.asVanillaIngredient(), drop.getInternal(), isWaterlogged, (MeshWithChance[])rolls.toArray(MeshWithChance[]::new)));
    }
}

