/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import novamachina.exnihilosequentia.world.item.Ore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeMessages {
    private static Logger log = LoggerFactory.getLogger(HandshakeMessages.class);

    private HandshakeMessages() {
    }

    static class C2SAcknowledge
    extends LoginIndexedMessage {
        C2SAcknowledge() {
        }

        @Nonnull
        static C2SAcknowledge decode(@Nonnull FriendlyByteBuf buf) {
            return new C2SAcknowledge();
        }

        void encode(@Nonnull FriendlyByteBuf buf) {
        }
    }

    static class LoginIndexedMessage
    implements IntSupplier {
        private int loginIndex;

        LoginIndexedMessage() {
        }

        @Override
        public int getAsInt() {
            return this.getLoginIndex();
        }

        int getLoginIndex() {
            return this.loginIndex;
        }

        void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }
    }

    public static class S2COreList
    extends LoginIndexedMessage {
        @Nullable
        private List<String> oreList;

        @Nonnull
        static S2COreList decode(@Nonnull FriendlyByteBuf buffer) {
            S2COreList message = new S2COreList();
            message.oreList = new ArrayList<String>();
            int count = buffer.readInt();
            for (int i = 0; i < count; ++i) {
                String ore = buffer.m_130277_();
                message.oreList.add(ore);
            }
            log.debug("Created ore list: " + message.oreList);
            return message;
        }

        @Nullable
        public List<String> getOreList() {
            return this.oreList;
        }

        void encode(@Nonnull FriendlyByteBuf buffer) {
            this.oreList = Ore.getEnabledOres();
            log.debug("Writing ore list: " + this.oreList);
            buffer.writeInt(this.oreList.size());
            for (String ore : this.oreList) {
                buffer.m_130070_(ore);
            }
        }
    }
}

