/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.recipes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.item.crafting.MeshWithChance;
import novamachina.novacore.data.recipes.RecipeBuilder;

public class SiftingRecipeBuilder
extends RecipeBuilder<SiftingRecipeBuilder> {
    private final Ingredient input;
    private final ItemStack drop;
    private final boolean isWaterlogged;
    private List<MeshWithChance> rolls;

    protected SiftingRecipeBuilder(Ingredient input, ItemStack drop, boolean isWaterlogged, MeshWithChance ... rolls) {
        super(EXNRecipeSerializers.SIFTING_RECIPE_SERIALIZER.recipeSerializer());
        this.input = input;
        this.drop = drop;
        this.isWaterlogged = isWaterlogged;
        this.rolls = Lists.newArrayList((Object[])rolls);
    }

    public static SiftingRecipeBuilder sifting(ItemLike input, ItemLike drop, MeshWithChance ... rolls) {
        return SiftingRecipeBuilder.sifting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), new ItemStack(drop), false, rolls);
    }

    public static SiftingRecipeBuilder sifting(ItemLike input, ItemLike drop, boolean isWaterlogged, MeshWithChance ... rolls) {
        return SiftingRecipeBuilder.sifting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), new ItemStack(drop), isWaterlogged, rolls);
    }

    public static SiftingRecipeBuilder sifting(ItemLike input, ItemStack drop, MeshWithChance ... rolls) {
        return SiftingRecipeBuilder.sifting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), drop, false, rolls);
    }

    public static SiftingRecipeBuilder sifting(ItemLike input, ItemStack drop, boolean isWaterlogged, MeshWithChance ... rolls) {
        return SiftingRecipeBuilder.sifting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), drop, isWaterlogged, rolls);
    }

    public static SiftingRecipeBuilder sifting(Ingredient input, ItemLike drop, MeshWithChance ... rolls) {
        return SiftingRecipeBuilder.sifting(input, new ItemStack(drop), false, rolls);
    }

    public static SiftingRecipeBuilder sifting(Ingredient input, ItemLike drop, boolean isWaterlogged, MeshWithChance ... rolls) {
        return SiftingRecipeBuilder.sifting(input, new ItemStack(drop), isWaterlogged, rolls);
    }

    public static SiftingRecipeBuilder sifting(Ingredient input, ItemStack drop, MeshWithChance ... rolls) {
        return SiftingRecipeBuilder.sifting(input, drop, false, rolls);
    }

    public static SiftingRecipeBuilder sifting(Ingredient input, ItemStack drop, boolean isWaterlogged, MeshWithChance ... rolls) {
        return new SiftingRecipeBuilder(input, drop, isWaterlogged, rolls);
    }

    protected void validate(ResourceLocation id) {
        Preconditions.checkNotNull((Object)this.input, (Object)"Input cannot be null.");
        Preconditions.checkNotNull((Object)this.drop, (Object)"Drop cannot be null.");
        Preconditions.checkArgument((!this.drop.m_41619_() ? 1 : 0) != 0, (Object)"Recipe needs at least one drop.");
        Preconditions.checkArgument((!this.rolls.isEmpty() ? 1 : 0) != 0, (Object)"Recipe needs at least one roll.");
    }

    public SiftingRecipeBuilder addRoll(MeshWithChance mesh) {
        this.rolls.add(mesh);
        return this;
    }

    protected SiftingRecipeResult getResult(ResourceLocation id) {
        return new SiftingRecipeResult(id);
    }

    public class SiftingRecipeResult
    extends RecipeBuilder.RecipeResult {
        public SiftingRecipeResult(ResourceLocation id) {
            super((RecipeBuilder)SiftingRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            json.add("input", SiftingRecipeBuilder.this.input.m_43942_());
            json.add("result", (JsonElement)this.serializeItemStack(SiftingRecipeBuilder.this.drop));
            JsonArray rollArray = new JsonArray();
            SiftingRecipeBuilder.this.rolls.forEach(roll -> rollArray.add(roll.serialize()));
            json.add("rolls", (JsonElement)rollArray);
            if (SiftingRecipeBuilder.this.isWaterlogged) {
                json.addProperty("waterlogged", Boolean.valueOf(true));
            }
        }

        private JsonObject serializeItemStack(@Nonnull ItemStack itemStack) {
            JsonObject obj = new JsonObject();
            ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
            if (resourceLocation != null) {
                obj.addProperty("item", resourceLocation.toString());
            }
            if (itemStack.m_41613_() > 1) {
                obj.addProperty("count", (Number)itemStack.m_41613_());
            }
            if (itemStack.m_41782_() && itemStack.m_41783_() != null) {
                obj.addProperty("nbt", itemStack.m_41783_().toString());
            }
            return obj;
        }
    }
}

