/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.tags;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import novamachina.exnihilosequentia.tags.ExNihiloTags;
import novamachina.exnihilosequentia.world.item.EXNItems;
import novamachina.exnihilosequentia.world.item.Ore;
import novamachina.exnihilosequentia.world.item.OreItem;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.exnihilosequentia.world.level.material.EXNFluids;
import novamachina.novacore.data.tags.IntrinsicTagBuilder;
import novamachina.novacore.data.tags.TagProvider;
import novamachina.novacore.world.item.ItemDefinition;
import novamachina.novacore.world.level.material.FluidDefinition;

public class EXNTagProvider
extends TagProvider {
    public EXNTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "exnihilosequentia", existingFileHelper);
    }

    protected void registerTags() {
        this.addBlocks();
        this.addFluids();
        this.addItems();
    }

    private void addItems() {
        this.addOres();
        this.addMeats();
        this.addHammers();
        this.addCrooks();
        this.addMisc();
        this.addWoodenBarrel();
        this.addWoodenCrucible();
        this.addWoodenSieve();
        this.addPebbles();
    }

    private void addPebbles() {
        this.addToTag(ExNihiloTags.PEBBLES, new ItemLike[]{EXNItems.PEBBLE_ANDESITE, EXNItems.PEBBLE_BASALT, EXNItems.PEBBLE_BLACKSTONE, EXNItems.PEBBLE_CALCITE, EXNItems.PEBBLE_DEEPSLATE, EXNItems.PEBBLE_DIORITE, EXNItems.PEBBLE_DRIPSTONE, EXNItems.PEBBLE_END_STONE, EXNItems.PEBBLE_GRANITE, EXNItems.PEBBLE_NETHERRACK, EXNItems.PEBBLE_STONE, EXNItems.PEBBLE_TUFF});
    }

    private void addWoodenSieve() {
        this.addToTag(ExNihiloTags.SIEVE, new ItemLike[]{EXNBlocks.ACACIA_SIEVE, EXNBlocks.BAMBOO_SIEVE, EXNBlocks.BIRCH_SIEVE, EXNBlocks.CHERRY_SIEVE, EXNBlocks.DARK_OAK_SIEVE, EXNBlocks.JUNGLE_SIEVE, EXNBlocks.MANGROVE_SIEVE, EXNBlocks.OAK_SIEVE, EXNBlocks.SPRUCE_SIEVE, EXNBlocks.CRIMSON_SIEVE, EXNBlocks.WARPED_SIEVE});
    }

    private void addWoodenCrucible() {
        this.addToTag(ExNihiloTags.CRUCIBLE, new ItemLike[]{EXNBlocks.ACACIA_CRUCIBLE, EXNBlocks.BAMBOO_CRUCIBLE, EXNBlocks.BIRCH_CRUCIBLE, EXNBlocks.CHERRY_CRUCIBLE, EXNBlocks.DARK_OAK_CRUCIBLE, EXNBlocks.JUNGLE_CRUCIBLE, EXNBlocks.MANGROVE_CRUCIBLE, EXNBlocks.OAK_CRUCIBLE, EXNBlocks.SPRUCE_CRUCIBLE, EXNBlocks.CRIMSON_CRUCIBLE, EXNBlocks.WARPED_CRUCIBLE});
    }

    private void addWoodenBarrel() {
        this.addToTag(ExNihiloTags.BARREL, new ItemLike[]{EXNBlocks.ACACIA_BARREL, EXNBlocks.BAMBOO_BARREL, EXNBlocks.BIRCH_BARREL, EXNBlocks.CHERRY_BARREL, EXNBlocks.DARK_OAK_BARREL, EXNBlocks.JUNGLE_BARREL, EXNBlocks.MANGROVE_BARREL, EXNBlocks.OAK_BARREL, EXNBlocks.SPRUCE_BARREL, EXNBlocks.CRIMSON_BARREL, EXNBlocks.WARPED_BARREL});
    }

    private void addMisc() {
        this.addToTag(ExNihiloTags.CLAY, new ItemLike[]{Items.f_42461_});
    }

    private void addCrooks() {
        this.addToTag(ExNihiloTags.CROOK, new ItemLike[]{EXNItems.CROOK_ANDESITE, EXNItems.CROOK_BAMBOO, EXNItems.CROOK_BASALT, EXNItems.CROOK_BLACKSTONE, EXNItems.CROOK_BONE, EXNItems.CROOK_CALCITE, EXNItems.CROOK_CHERRY, EXNItems.CROOK_COPPER, EXNItems.CROOK_DEEPSLATE, EXNItems.CROOK_DIAMOND, EXNItems.CROOK_DIORITE, EXNItems.CROOK_DRIPSTONE, EXNItems.CROOK_GOLD, EXNItems.CROOK_GRANITE, EXNItems.CROOK_IRON, EXNItems.CROOK_NETHER_BRICK, EXNItems.CROOK_NETHERITE, EXNItems.CROOK_RED_NETHER_BRICK, EXNItems.CROOK_STONE, EXNItems.CROOK_TERRACOTTA, EXNItems.CROOK_TUFF, EXNItems.CROOK_WOOD});
    }

    private void addHammers() {
        this.addToTag(ExNihiloTags.HAMMER, new ItemLike[]{EXNItems.HAMMER_ANDESITE, EXNItems.HAMMER_BAMBOO, EXNItems.HAMMER_BASALT, EXNItems.HAMMER_BLACKSTONE, EXNItems.HAMMER_BONE, EXNItems.HAMMER_CALCITE, EXNItems.HAMMER_CHERRY, EXNItems.HAMMER_COPPER, EXNItems.HAMMER_DEEPSLATE, EXNItems.HAMMER_DIAMOND, EXNItems.HAMMER_DIORITE, EXNItems.HAMMER_DRIPSTONE, EXNItems.HAMMER_GOLD, EXNItems.HAMMER_GRANITE, EXNItems.HAMMER_IRON, EXNItems.HAMMER_NETHER_BRICK, EXNItems.HAMMER_NETHERITE, EXNItems.HAMMER_RED_NETHER_BRICK, EXNItems.HAMMER_STONE, EXNItems.HAMMER_TERRACOTTA, EXNItems.HAMMER_TUFF, EXNItems.HAMMER_WOOD});
    }

    private void addMeats() {
        this.addUncooked();
        this.addCooked();
    }

    private void addCooked() {
        this.addToTag(ExNihiloTags.MEAT_COOKED, new ItemLike[]{Items.f_42582_, Items.f_42530_, Items.f_42659_, Items.f_42486_, Items.f_42698_, Items.f_42531_, Items.f_42580_});
    }

    private void addUncooked() {
        this.addToTag(ExNihiloTags.MEAT_UNCOOKED, new ItemLike[]{Items.f_42581_, Items.f_42526_, Items.f_42658_, Items.f_42485_, Items.f_42697_, Items.f_42527_, Items.f_42579_});
    }

    private void addOres() {
        this.addOre(EXNItems.IRON, new ExNihiloTags.OreTag(EXNItems.IRON));
        this.addOre(EXNItems.GOLD, new ExNihiloTags.OreTag(EXNItems.GOLD));
        this.addOre(EXNItems.COPPER, new ExNihiloTags.OreTag(EXNItems.COPPER));
        this.addOre(EXNItems.LEAD, new ExNihiloTags.OreTag(EXNItems.LEAD));
        this.addOre(EXNItems.NICKEL, new ExNihiloTags.OreTag(EXNItems.NICKEL));
        this.addOre(EXNItems.SILVER, new ExNihiloTags.OreTag(EXNItems.SILVER));
        this.addOre(EXNItems.TIN, new ExNihiloTags.OreTag(EXNItems.TIN));
        this.addOre(EXNItems.ALUMINUM, new ExNihiloTags.OreTag(EXNItems.ALUMINUM));
        this.addOre(EXNItems.PLATINUM, new ExNihiloTags.OreTag(EXNItems.PLATINUM));
        this.addOre(EXNItems.URANIUM, new ExNihiloTags.OreTag(EXNItems.URANIUM));
        this.addOre(EXNItems.ZINC, new ExNihiloTags.OreTag(EXNItems.ZINC));
    }

    private void addOre(Ore ore, ExNihiloTags.OreTag tags) {
        this.addIngot(ore, tags);
        this.addPiece(ore);
        this.addRaw(ore, tags);
        this.addNugget(ore, tags);
    }

    private void addNugget(Ore ore, ExNihiloTags.OreTag tags) {
        Either<ItemDefinition<OreItem>, Item> either = ore.getNuggetItem();
        if (either.left().isPresent()) {
            this.addToTag(tags.getNuggetTag(), new ItemLike[]{(ItemLike)either.left().get()});
            this.getItemBuilder(Tags.Items.NUGGETS).add(new TagKey[]{tags.getNuggetTag()});
        }
    }

    private void addRaw(Ore ore, ExNihiloTags.OreTag tags) {
        Either<ItemDefinition<OreItem>, Item> either = ore.getRawOreItem();
        if (either.left().isPresent()) {
            this.addToTag(tags.getRawMaterialTag(), new ItemLike[]{(ItemLike)either.left().get()});
            this.getItemBuilder(Tags.Items.RAW_MATERIALS).add(new TagKey[]{tags.getRawMaterialTag()});
        }
    }

    private void addPiece(Ore ore) {
        this.addToTag(ExNihiloTags.PIECE, new ItemLike[]{ore.getPieceItem()});
    }

    private void addIngot(Ore ore, ExNihiloTags.OreTag tags) {
        Either<ItemDefinition<OreItem>, Item> either = ore.getIngotItem();
        if (either.left().isPresent()) {
            this.addToTag(tags.getIngotTag(), new ItemLike[]{(ItemLike)either.left().get()});
            this.getItemBuilder(Tags.Items.INGOTS).add(new TagKey[]{tags.getIngotTag()});
        }
    }

    private void addFluids() {
        this.addToTag(FluidTags.f_13131_, new FluidDefinition[]{EXNFluids.SEA_WATER});
    }

    private void addBlocks() {
        this.getBlockBuilder(ExNihiloTags.INFESTABLE).add(new TagKey[]{BlockTags.f_13035_});
        this.getBlockBuilder(ExNihiloTags.MINEABLE_WITH_HAMMER).add((Object[])new Block[]{Blocks.f_49994_, Blocks.f_49992_, Blocks.f_50584_, Blocks.f_50585_, Blocks.f_50586_, Blocks.f_50587_, Blocks.f_50588_, Blocks.f_50594_, Blocks.f_50595_, Blocks.f_50596_, Blocks.f_50597_, Blocks.f_50598_, EXNBlocks.STONE_BARREL.block(), EXNBlocks.FIRED_CRUCIBLE.block()}).add(new TagKey[]{BlockTags.f_144282_});
        ((IntrinsicTagBuilder)this.getBlockBuilder(ExNihiloTags.MINEABLE_WITH_CROOK).add(new TagKey[]{BlockTags.f_13035_})).add((Object[])new Block[]{EXNBlocks.INFESTING_LEAVES.block(), EXNBlocks.INFESTED_LEAVES.block()});
        this.addToTag(BlockTags.f_144280_, new Block[]{EXNBlocks.ACACIA_BARREL.block(), EXNBlocks.BAMBOO_BARREL.block(), EXNBlocks.BIRCH_BARREL.block(), EXNBlocks.CHERRY_BARREL.block(), EXNBlocks.CRIMSON_BARREL.block(), EXNBlocks.DARK_OAK_BARREL.block(), EXNBlocks.JUNGLE_BARREL.block(), EXNBlocks.MANGROVE_BARREL.block(), EXNBlocks.OAK_BARREL.block(), EXNBlocks.SPRUCE_BARREL.block(), EXNBlocks.WARPED_BARREL.block(), EXNBlocks.ACACIA_CRUCIBLE.block(), EXNBlocks.BAMBOO_CRUCIBLE.block(), EXNBlocks.BIRCH_CRUCIBLE.block(), EXNBlocks.CHERRY_CRUCIBLE.block(), EXNBlocks.CRIMSON_CRUCIBLE.block(), EXNBlocks.DARK_OAK_CRUCIBLE.block(), EXNBlocks.JUNGLE_CRUCIBLE.block(), EXNBlocks.MANGROVE_CRUCIBLE.block(), EXNBlocks.OAK_CRUCIBLE.block(), EXNBlocks.SPRUCE_CRUCIBLE.block(), EXNBlocks.WARPED_CRUCIBLE.block(), EXNBlocks.ACACIA_SIEVE.block(), EXNBlocks.BAMBOO_SIEVE.block(), EXNBlocks.BIRCH_SIEVE.block(), EXNBlocks.CHERRY_SIEVE.block(), EXNBlocks.CRIMSON_SIEVE.block(), EXNBlocks.DARK_OAK_SIEVE.block(), EXNBlocks.JUNGLE_SIEVE.block(), EXNBlocks.MANGROVE_SIEVE.block(), EXNBlocks.OAK_SIEVE.block(), EXNBlocks.SPRUCE_SIEVE.block(), EXNBlocks.WARPED_SIEVE.block()});
        this.addToTag(BlockTags.f_144283_, new Block[]{EXNBlocks.CRUSHED_ANDESITE.block(), EXNBlocks.CRUSHED_BASALT.block(), EXNBlocks.CRUSHED_BLACKSTONE.block(), EXNBlocks.CRUSHED_CALCITE.block(), EXNBlocks.CRUSHED_DEEPSLATE.block(), EXNBlocks.CRUSHED_DIORITE.block(), EXNBlocks.CRUSHED_DRIPSTONE.block(), EXNBlocks.CRUSHED_END_STONE.block(), EXNBlocks.CRUSHED_GRANITE.block(), EXNBlocks.CRUSHED_NETHERRACK.block(), EXNBlocks.CRUSHED_TUFF.block(), EXNBlocks.DUST.block(), EXNBlocks.UNFIRED_CRUCIBLE.block()});
    }
}

