/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;

public class DollItem
extends Item {
    @Nonnull
    private final String entityModId;
    @Nonnull
    private final String entityName;
    @Nonnull
    private final String fluidModId;
    @Nonnull
    private final String fluidName;
    @Nonnull
    private final String tooltip;
    private final double yOffset;

    public DollItem(@Nonnull String entityModId, @Nonnull String entityName, @Nonnull String fluidModId, @Nonnull String fluidName, double yOffset, @Nonnull String tooltip) {
        super(new Item.Properties());
        this.entityModId = entityModId;
        this.entityName = entityName;
        this.fluidModId = fluidModId;
        this.fluidName = fluidName;
        this.yOffset = yOffset;
        this.tooltip = tooltip;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)this.tooltip));
    }

    @Nonnull
    public String getDollName() {
        return this.entityName + "_doll";
    }

    @Nonnull
    public String getDollType() {
        return this.entityName;
    }

    public Fluid getSpawnFluid() {
        ResourceLocation fluidLocation = new ResourceLocation(this.fluidModId, this.fluidName);
        if (ForgeRegistries.FLUIDS.containsKey(fluidLocation)) {
            return (Fluid)ForgeRegistries.FLUIDS.getValue(fluidLocation);
        }
        return Fluids.f_76191_;
    }

    public boolean spawnMob(@Nonnull Level world, @Nonnull BlockPos pos) {
        Entity spawnee;
        EntityType entityType;
        ResourceLocation spawneeResourceLocation = new ResourceLocation(this.entityModId, this.entityName);
        if (ForgeRegistries.ENTITY_TYPES.containsKey(spawneeResourceLocation) && (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(spawneeResourceLocation)) != null && (spawnee = entityType.m_20615_(world)) != null) {
            spawnee.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_() + this.yOffset, (double)pos.m_123343_());
            return world.m_7967_(spawnee);
        }
        return false;
    }
}

