/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemStackHandler;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.world.level.block.entity.CrucibleBlockEntity;

public class MeltableItemHandler
extends ItemStackHandler {
    private boolean crucibleHasRoom = true;
    @Nullable
    private CrucibleBlockEntity.CrucibleType type;

    public MeltableItemHandler(@Nonnull CrucibleBlockEntity.CrucibleType crucibleType) {
        super(1);
        this.type = crucibleType;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.crucibleHasRoom) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public void setCrucibleHasRoom(boolean crucibleHasRoom) {
        this.crucibleHasRoom = crucibleHasRoom;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.type == null) {
            return false;
        }
        return ExNihiloRegistries.CRUCIBLE_REGISTRY.isMeltable((ItemLike)stack.m_41720_(), this.type.getLevel());
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return 3;
    }

    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128379_("hasRoom", this.crucibleHasRoom);
        if (this.type != null) {
            nbt.m_128359_("type", this.type.getName());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.crucibleHasRoom = nbt.m_128471_("hasRoom");
        this.type = CrucibleBlockEntity.CrucibleType.getTypeByName(nbt.m_128461_("type"));
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }
}

