/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.level.block.entity.mode;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import novamachina.exnihilosequentia.world.level.block.entity.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.world.level.block.entity.mode.BlockBarrelMode;
import novamachina.exnihilosequentia.world.level.block.entity.mode.CompostBarrelMode;
import novamachina.exnihilosequentia.world.level.block.entity.mode.EmptyBarrelMode;
import novamachina.exnihilosequentia.world.level.block.entity.mode.FluidTransformBarrelMode;
import novamachina.exnihilosequentia.world.level.block.entity.mode.FluidsBarrelMode;
import novamachina.exnihilosequentia.world.level.block.entity.mode.MobSpawnBarrelMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarrelModeRegistry {
    private static Logger log = LoggerFactory.getLogger(BarrelModeRegistry.class);
    @Nonnull
    private static final Map<String, Supplier<AbstractBarrelMode>> modeNameMap = new HashMap<String, Supplier<AbstractBarrelMode>>();
    @Nonnull
    private static final Map<TriggerType, ArrayList<Supplier<AbstractBarrelMode>>> modeMap = new EnumMap<TriggerType, ArrayList<Supplier<AbstractBarrelMode>>>(TriggerType.class);

    @Nullable
    public static AbstractBarrelMode getModeFromName(@Nonnull String barrelMode) {
        return (AbstractBarrelMode)((Supplier)modeNameMap.getOrDefault(barrelMode, null)).get();
    }

    @Nonnull
    public static List<Supplier<AbstractBarrelMode>> getModes(@Nonnull TriggerType type) {
        log.debug("Getting barrel mode, Trigger: " + type);
        return modeMap.get((Object)type);
    }

    public static void initialize() {
        log.debug("Adding barrel modes");
        BarrelModeRegistry.addMode(() -> new EmptyBarrelMode("empty"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new CompostBarrelMode("compost"), TriggerType.ITEM);
        BarrelModeRegistry.addMode(() -> new FluidsBarrelMode("fluid"), TriggerType.ITEM);
        BarrelModeRegistry.addMode(() -> new BlockBarrelMode("block"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new MobSpawnBarrelMode("mob"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new FluidTransformBarrelMode("transform"), TriggerType.NONE);
    }

    public static void addMode(@Nonnull Supplier<AbstractBarrelMode> mode, @Nonnull TriggerType type) {
        log.debug("Adding mode: " + mode + ", Trigger: " + type);
        ArrayList<Supplier<AbstractBarrelMode>> list = modeMap.get((Object)type);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(mode);
        modeMap.put(type, list);
        modeNameMap.put(mode.get().getModeName(), mode);
    }

    public static enum TriggerType {
        ITEM,
        FLUID,
        NONE;

    }
}

