/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.level.block.entity.mode;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.world.level.block.entity.BarrelBlockEntity;
import novamachina.exnihilosequentia.world.level.block.entity.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.world.level.block.entity.mode.BarrelModeRegistry;

public class EmptyBarrelMode
extends AbstractBarrelMode {
    public EmptyBarrelMode(@Nonnull String name) {
        super(name);
    }

    @Override
    public void tick(@Nonnull BarrelBlockEntity barrelTile) {
    }

    @Override
    @Nonnull
    public InteractionResult onBlockActivated(@Nonnull BarrelBlockEntity barrelTile, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull IFluidHandler fluidHandler, @Nonnull IItemHandler itemHandler) {
        if (!player.m_21120_(handIn).m_41619_()) {
            ItemStack stack = player.m_21120_(handIn);
            List<Supplier<AbstractBarrelMode>> modes = BarrelModeRegistry.getModes(BarrelModeRegistry.TriggerType.ITEM);
            for (Supplier<AbstractBarrelMode> mode : modes) {
                if (!mode.get().isTriggerItem(stack)) continue;
                barrelTile.setMode(mode.get());
                barrelTile.getMode().onBlockActivated(barrelTile, player, handIn, fluidHandler, itemHandler);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canFillWithFluid(@Nonnull BarrelBlockEntity barrel) {
        return true;
    }

    @Override
    public boolean isEmptyMode() {
        return true;
    }

    @Override
    protected boolean isTriggerItem(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    public void read(@Nonnull CompoundTag nbt) {
    }

    @Override
    @Nonnull
    public CompoundTag write() {
        return new CompoundTag();
    }

    @Override
    protected void spawnParticle(@Nonnull BarrelBlockEntity barrelTile) {
    }

    @Override
    @Nonnull
    public List<Component> getWailaInfo(@Nonnull BarrelBlockEntity barrelTile) {
        return new ArrayList<Component>();
    }

    @Override
    @Nonnull
    public ItemStack handleInsert(@Nonnull BarrelBlockEntity barrelTile, @Nonnull ItemStack stack, boolean simulate) {
        if (ExNihiloRegistries.COMPOST_REGISTRY.containsSolid((ItemLike)stack.m_41720_())) {
            barrelTile.setMode("compost");
            ItemStack returnStack = barrelTile.getMode().handleInsert(barrelTile, stack, simulate);
            if (simulate) {
                barrelTile.setMode("empty");
            }
            return returnStack;
        }
        return stack;
    }
}

