/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item.crafting;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.HangingLightsConnectionItem;
import me.paulf.fairylights.server.item.crafting.CopyColorRecipe;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import me.paulf.fairylights.util.Blender;
import me.paulf.fairylights.util.OreDictUtils;
import me.paulf.fairylights.util.Utils;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import me.paulf.fairylights.util.crafting.GenericRecipeBuilder;
import me.paulf.fairylights.util.crafting.ingredient.BasicAuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.BasicRegularIngredient;
import me.paulf.fairylights.util.crafting.ingredient.InertBasicAuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.LazyTagIngredient;
import me.paulf.fairylights.util.crafting.ingredient.RegularIngredient;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="fairylights")
public final class FLCraftingRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"fairylights");
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> HANGING_LIGHTS = REG.register("crafting_special_hanging_lights", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createHangingLights));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> HANGING_LIGHTS_AUGMENTATION = REG.register("crafting_special_hanging_lights_augmentation", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createHangingLightsAugmentation));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> TINSEL_GARLAND = REG.register("crafting_special_tinsel_garland", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createTinselGarland));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> PENNANT_BUNTING = REG.register("crafting_special_pennant_bunting", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createPennantBunting));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> PENNANT_BUNTING_AUGMENTATION = REG.register("crafting_special_pennant_bunting_augmentation", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createPennantBuntingAugmentation));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> TRIANGLE_PENNANT = REG.register("crafting_special_triangle_pennant", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createTrianglePennant));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> SPEARHEAD_PENNANT = REG.register("crafting_special_spearhead_pennant", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSpearheadPennant));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> SWALLOWTAIL_PENNANT = REG.register("crafting_special_swallowtail_pennant", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSwallowtailPennant));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> SQUARE_PENNANT = REG.register("crafting_special_square_pennant", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSquarePennant));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> FAIRY_LIGHT = REG.register("crafting_special_fairy_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createFairyLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> PAPER_LANTERN = REG.register("crafting_special_paper_lantern", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createPaperLantern));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> ORB_LANTERN = REG.register("crafting_special_orb_lantern", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createOrbLantern));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> FLOWER_LIGHT = REG.register("crafting_special_flower_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createFlowerLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> CANDLE_LANTERN_LIGHT = REG.register("crafting_special_candle_lantern_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createCandleLanternLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> OIL_LANTERN_LIGHT = REG.register("crafting_special_oil_lantern_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createOilLanternLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> JACK_O_LANTERN = REG.register("crafting_special_jack_o_lantern", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createJackOLantern));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> SKULL_LIGHT = REG.register("crafting_special_skull_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSkullLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> GHOST_LIGHT = REG.register("crafting_special_ghost_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createGhostLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> SPIDER_LIGHT = REG.register("crafting_special_spider_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSpiderLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> WITCH_LIGHT = REG.register("crafting_special_witch_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createWitchLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> SNOWFLAKE_LIGHT = REG.register("crafting_special_snowflake_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSnowflakeLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> HEART_LIGHT = REG.register("crafting_special_heart_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createHeartLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> MOON_LIGHT = REG.register("crafting_special_moon_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createMoonLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> STAR_LIGHT = REG.register("crafting_special_star_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createStarLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> ICICLE_LIGHTS = REG.register("crafting_special_icicle_lights", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createIcicleLights));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> METEOR_LIGHT = REG.register("crafting_special_meteor_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createMeteorLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> LIGHT_TWINKLE = REG.register("crafting_special_light_twinkle", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createLightTwinkle));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> COLOR_CHANGING_LIGHT = REG.register("crafting_special_color_changing_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createColorChangingLight));
    public static final RegistryObject<RecipeSerializer<GenericRecipe>> EDIT_COLOR = REG.register("crafting_special_edit_color", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createDyeColor));
    public static final RegistryObject<? extends RecipeSerializer<CustomRecipe>> COPY_COLOR = REG.register("crafting_special_copy_color", () -> new SimpleCraftingRecipeSerializer(CopyColorRecipe::new));
    public static final TagKey<Item> LIGHTS = ItemTags.create((ResourceLocation)new ResourceLocation("fairylights:lights"));
    public static final TagKey<Item> TWINKLING_LIGHTS = ItemTags.create((ResourceLocation)new ResourceLocation("fairylights:twinkling_lights"));
    public static final TagKey<Item> PENNANTS = ItemTags.create((ResourceLocation)new ResourceLocation("fairylights:pennants"));
    public static final TagKey<Item> DYEABLE = ItemTags.create((ResourceLocation)new ResourceLocation("fairylights:dyeable"));
    public static final TagKey<Item> DYEABLE_LIGHTS = ItemTags.create((ResourceLocation)new ResourceLocation("fairylights:dyeable_lights"));
    public static final RegularIngredient DYE_SUBTYPE_INGREDIENT = new BasicRegularIngredient(LazyTagIngredient.of((TagKey<Item>)Tags.Items.DYES)){

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            return DyeableItem.getDyeColor(output).map(dye -> ImmutableList.of(OreDictUtils.getDyes(dye))).orElse(ImmutableList.of());
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public void matched(ItemStack ingredient, CompoundTag nbt) {
            DyeableItem.setColor(nbt, OreDictUtils.getDyeColor(ingredient));
        }
    };

    private FLCraftingRecipes() {
    }

    private static GenericRecipe createDyeColor(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)EDIT_COLOR).withShape("I").withIngredient('I', DYEABLE).withOutput('I').withAuxiliaryIngredient(new BasicAuxiliaryIngredient<Blender>((Ingredient)LazyTagIngredient.of((TagKey<Item>)Tags.Items.DYES), true, 8){

            @Override
            public Blender accumulator() {
                return new Blender();
            }

            @Override
            public void consume(Blender data, ItemStack ingredient) {
                data.add(DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient)));
            }

            @Override
            public boolean finish(Blender data, CompoundTag nbt) {
                DyeableItem.setColor(nbt, data.blend());
                return false;
            }
        }).build();
    }

    private static GenericRecipe createLightTwinkle(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)LIGHT_TWINKLE).withShape("L").withIngredient('L', TWINKLING_LIGHTS).withOutput('L').withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE), true, 1){

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                return FLCraftingRecipes.useInputsForTagBool(output, "twinkle", true) ? super.getInput(output) : ImmutableList.of();
            }

            @Override
            public void present(CompoundTag nbt) {
                nbt.m_128379_("twinkle", true);
            }

            @Override
            public void absent(CompoundTag nbt) {
                nbt.m_128379_("twinkle", false);
            }

            @Override
            public void addTooltip(List<Component> tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.twinkling_lights.glowstone"));
            }
        }).build();
    }

    private static GenericRecipe createColorChangingLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)COLOR_CHANGING_LIGHT).withShape("IG").withIngredient('I', DYEABLE_LIGHTS).withOutput('I').withIngredient('G', (TagKey<Item>)Tags.Items.NUGGETS_GOLD).withAuxiliaryIngredient(new BasicAuxiliaryIngredient<ListTag>((Ingredient)LazyTagIngredient.of((TagKey<Item>)Tags.Items.DYES), true, 8){

            @Override
            public ListTag accumulator() {
                return new ListTag();
            }

            @Override
            public void consume(ListTag data, ItemStack ingredient) {
                data.add((Object)IntTag.m_128679_((int)DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient))));
            }

            @Override
            public boolean finish(ListTag data, CompoundTag nbt) {
                if (!data.isEmpty()) {
                    if (nbt.m_128425_("color", 3)) {
                        data.add(0, (Tag)IntTag.m_128679_((int)nbt.m_128451_("color")));
                        nbt.m_128473_("color");
                    }
                    nbt.m_128365_("colors", (Tag)data);
                }
                return false;
            }
        }).build();
    }

    private static GenericRecipe createHangingLights(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)HANGING_LIGHTS, (Item)FLItems.HANGING_LIGHTS.get()).withShape("I-I").withIngredient('I', (TagKey<Item>)Tags.Items.INGOTS_IRON).withIngredient('-', (TagKey<Item>)Tags.Items.STRING).withAuxiliaryIngredient(new LightIngredient(true)).withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of((TagKey<Item>)Tags.Items.DYES_WHITE), false, 1){

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                CompoundTag tag = output.m_41783_();
                return tag != null && HangingLightsConnectionItem.getString(tag) == StringTypes.WHITE_STRING.get() ? super.getInput(output) : ImmutableList.of();
            }

            @Override
            public void present(CompoundTag nbt) {
                HangingLightsConnectionItem.setString(nbt, (StringType)StringTypes.WHITE_STRING.get());
            }

            @Override
            public void absent(CompoundTag nbt) {
                HangingLightsConnectionItem.setString(nbt, (StringType)StringTypes.BLACK_STRING.get());
            }

            @Override
            public void addTooltip(List<Component> tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.hangingLights.string"));
            }
        }).build();
    }

    private static boolean useInputsForTagBool(ItemStack output, String key, boolean value) {
        CompoundTag compound = output.m_41783_();
        return compound != null && compound.m_128471_(key) == value;
    }

    private static GenericRecipe createHangingLightsAugmentation(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)HANGING_LIGHTS_AUGMENTATION, (Item)FLItems.HANGING_LIGHTS.get()).withShape("F").withIngredient('F', new BasicRegularIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FLItems.HANGING_LIGHTS.get()})){

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.m_43908_()).map(ItemStack::m_41777_).flatMap(stack -> {
                    stack.m_41751_(new CompoundTag());
                    return FLCraftingRecipes.makeHangingLightsExamples(stack).stream();
                }).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                ItemStack stack = output.m_41777_();
                CompoundTag compound = stack.m_41783_();
                if (compound == null) {
                    return ImmutableList.of();
                }
                stack.m_41764_(1);
                return ImmutableList.of((Object)ImmutableList.of((Object)stack));
            }

            @Override
            public void matched(ItemStack ingredient, CompoundTag nbt) {
                CompoundTag compound = ingredient.m_41783_();
                if (compound != null) {
                    nbt.m_128391_(compound);
                }
            }
        }).withAuxiliaryIngredient(new LightIngredient(true){

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return ImmutableList.of();
            }

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                return ImmutableList.of();
            }
        }).build();
    }

    private static ImmutableList<ItemStack> makeHangingLightsExamples(ItemStack stack) {
        return ImmutableList.of((Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.CYAN, DyeColor.MAGENTA, DyeColor.CYAN, DyeColor.WHITE), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.CYAN, DyeColor.LIGHT_BLUE), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.LIGHT_GRAY, DyeColor.PINK, DyeColor.CYAN, DyeColor.GREEN), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.LIGHT_GRAY, DyeColor.PURPLE, DyeColor.LIGHT_GRAY, DyeColor.GREEN), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.CYAN, DyeColor.YELLOW, DyeColor.CYAN, DyeColor.PURPLE));
    }

    public static ItemStack makeHangingLights(ItemStack base, DyeColor ... colors) {
        ItemStack stack = base.m_41777_();
        CompoundTag compound = stack.m_41783_();
        ListTag lights = new ListTag();
        for (DyeColor color : colors) {
            lights.add((Object)DyeableItem.setColor(new ItemStack((ItemLike)FLItems.FAIRY_LIGHT.get()), color).m_41739_(new CompoundTag()));
        }
        if (compound == null) {
            compound = new CompoundTag();
            stack.m_41751_(compound);
        }
        compound.m_128365_("pattern", (Tag)lights);
        HangingLightsConnectionItem.setString(compound, (StringType)StringTypes.BLACK_STRING.get());
        return stack;
    }

    private static GenericRecipe createTinselGarland(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)TINSEL_GARLAND, (Item)FLItems.TINSEL.get()).withShape(" P ", "I-I", " D ").withIngredient('P', Items.f_42516_).withIngredient('I', (TagKey<Item>)Tags.Items.INGOTS_IRON).withIngredient('-', (TagKey<Item>)Tags.Items.STRING).withIngredient('D', DYE_SUBTYPE_INGREDIENT).build();
    }

    private static GenericRecipe createPennantBunting(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)PENNANT_BUNTING, (Item)FLItems.PENNANT_BUNTING.get()).withShape("I-I").withIngredient('I', (TagKey<Item>)Tags.Items.INGOTS_IRON).withIngredient('-', (TagKey<Item>)Tags.Items.STRING).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static GenericRecipe createPennantBuntingAugmentation(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)PENNANT_BUNTING_AUGMENTATION, (Item)FLItems.PENNANT_BUNTING.get()).withShape("B").withIngredient('B', new BasicRegularIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FLItems.PENNANT_BUNTING.get()})){

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.m_43908_()).map(ItemStack::m_41777_).flatMap(stack -> {
                    stack.m_41751_(new CompoundTag());
                    return FLCraftingRecipes.makePennantExamples(stack).stream();
                }).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                CompoundTag compound = output.m_41783_();
                if (compound == null) {
                    return ImmutableList.of();
                }
                return ImmutableList.of(FLCraftingRecipes.makePennantExamples(output));
            }

            @Override
            public void matched(ItemStack ingredient, CompoundTag nbt) {
                CompoundTag compound = ingredient.m_41783_();
                if (compound != null) {
                    nbt.m_128391_(compound);
                }
            }
        }).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static ImmutableList<ItemStack> makePennantExamples(ItemStack stack) {
        return ImmutableList.of((Object)FLCraftingRecipes.makePennant(stack, DyeColor.BLUE, DyeColor.YELLOW, DyeColor.RED), (Object)FLCraftingRecipes.makePennant(stack, DyeColor.PINK, DyeColor.LIGHT_BLUE), (Object)FLCraftingRecipes.makePennant(stack, DyeColor.ORANGE, DyeColor.WHITE), (Object)FLCraftingRecipes.makePennant(stack, DyeColor.LIME, DyeColor.YELLOW));
    }

    public static ItemStack makePennant(ItemStack base, DyeColor ... colors) {
        ItemStack stack = base.m_41777_();
        CompoundTag compound = stack.m_41783_();
        ListTag pennants = new ListTag();
        for (DyeColor color : colors) {
            ItemStack pennant = new ItemStack((ItemLike)FLItems.TRIANGLE_PENNANT.get());
            DyeableItem.setColor(pennant, color);
            pennants.add((Object)pennant.m_41739_(new CompoundTag()));
        }
        if (compound == null) {
            compound = new CompoundTag();
            stack.m_41751_(compound);
        }
        compound.m_128365_("pattern", (Tag)pennants);
        compound.m_128365_("text", (Tag)StyledString.serialize(new StyledString()));
        return stack;
    }

    private static GenericRecipe createPennant(ResourceLocation name, Supplier<RecipeSerializer<GenericRecipe>> serializer, Item item, String pattern) {
        return new GenericRecipeBuilder(name, serializer, item).withShape("- -", "PDP", pattern).withIngredient('P', Items.f_42516_).withIngredient('-', (TagKey<Item>)Tags.Items.STRING).withIngredient('D', DYE_SUBTYPE_INGREDIENT).build();
    }

    private static GenericRecipe createTrianglePennant(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createPennant(name, TRIANGLE_PENNANT, (Item)FLItems.TRIANGLE_PENNANT.get(), " P ");
    }

    private static GenericRecipe createSpearheadPennant(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createPennant(name, SPEARHEAD_PENNANT, (Item)FLItems.SPEARHEAD_PENNANT.get(), " PP");
    }

    private static GenericRecipe createSwallowtailPennant(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createPennant(name, SWALLOWTAIL_PENNANT, (Item)FLItems.SWALLOWTAIL_PENNANT.get(), "P P");
    }

    private static GenericRecipe createSquarePennant(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createPennant(name, SQUARE_PENNANT, (Item)FLItems.SQUARE_PENNANT.get(), "PPP");
    }

    private static GenericRecipe createFairyLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, FAIRY_LIGHT, FLItems.FAIRY_LIGHT, b -> b.withShape(" I ", "IDI", " G ").withIngredient('G', (TagKey<Item>)Tags.Items.GLASS_PANES_COLORLESS));
    }

    private static GenericRecipe createPaperLantern(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, PAPER_LANTERN, FLItems.PAPER_LANTERN, b -> b.withShape(" I ", "PDP", "PPP").withIngredient('P', Items.f_42516_));
    }

    private static GenericRecipe createOrbLantern(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, ORB_LANTERN, FLItems.ORB_LANTERN, b -> b.withShape(" I ", "SDS", " W ").withIngredient('S', (TagKey<Item>)Tags.Items.STRING).withIngredient('W', Items.f_41870_));
    }

    private static GenericRecipe createFlowerLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, FLOWER_LIGHT, FLItems.FLOWER_LIGHT, b -> b.withShape(" I ", "RDB", " Y ").withIngredient('R', Items.f_41940_).withIngredient('Y', Items.f_41939_).withIngredient('B', Items.f_41941_));
    }

    private static GenericRecipe createCandleLanternLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, CANDLE_LANTERN_LIGHT, FLItems.CANDLE_LANTERN_LIGHT, b -> b.withShape(" I ", "GDG", "IGI").withIngredient('G', (TagKey<Item>)Tags.Items.NUGGETS_GOLD));
    }

    private static GenericRecipe createOilLanternLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, OIL_LANTERN_LIGHT, FLItems.OIL_LANTERN_LIGHT, b -> b.withShape(" I ", "SDS", "IGI").withIngredient('S', Items.f_42398_).withIngredient('G', (TagKey<Item>)Tags.Items.GLASS_PANES_COLORLESS));
    }

    private static GenericRecipe createJackOLantern(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, JACK_O_LANTERN, FLItems.JACK_O_LANTERN, b -> b.withShape(" I ", "SDS", "GPG").withIngredient('S', (TagKey<Item>)ItemTags.f_13175_).withIngredient('G', Items.f_42000_).withIngredient('P', Items.f_42055_));
    }

    private static GenericRecipe createSkullLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, SKULL_LIGHT, FLItems.SKULL_LIGHT, b -> b.withShape(" I ", "IDI", " B ").withIngredient('B', (TagKey<Item>)Tags.Items.BONES));
    }

    private static GenericRecipe createGhostLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, GHOST_LIGHT, FLItems.GHOST_LIGHT, b -> b.withShape(" I ", "PDP", "IGI").withIngredient('P', Items.f_42516_).withIngredient('G', (TagKey<Item>)Tags.Items.GLASS_PANES_WHITE));
    }

    private static GenericRecipe createSpiderLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, SPIDER_LIGHT, FLItems.SPIDER_LIGHT, b -> b.withShape(" I ", "WDW", "SES").withIngredient('W', Items.f_41863_).withIngredient('S', (TagKey<Item>)Tags.Items.STRING).withIngredient('E', Items.f_42591_));
    }

    private static GenericRecipe createWitchLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, WITCH_LIGHT, FLItems.WITCH_LIGHT, b -> b.withShape(" I ", "BDW", " S ").withIngredient('B', Items.f_42590_).withIngredient('W', Items.f_42405_).withIngredient('S', Items.f_42398_));
    }

    private static GenericRecipe createSnowflakeLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, SNOWFLAKE_LIGHT, FLItems.SNOWFLAKE_LIGHT, b -> b.withShape(" I ", "SDS", " G ").withIngredient('S', Items.f_42452_).withIngredient('G', (TagKey<Item>)Tags.Items.GLASS_PANES_WHITE));
    }

    private static GenericRecipe createHeartLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, HEART_LIGHT, FLItems.HEART_LIGHT, b -> b.withShape(" I ", "IDI", " G ").withIngredient('G', (TagKey<Item>)Tags.Items.GLASS_PANES_RED));
    }

    private static GenericRecipe createMoonLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, MOON_LIGHT, FLItems.MOON_LIGHT, b -> b.withShape(" I ", "GDG", " C ").withIngredient('G', (TagKey<Item>)Tags.Items.GLASS_PANES_WHITE).withIngredient('C', Items.f_42524_));
    }

    private static GenericRecipe createStarLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, STAR_LIGHT, FLItems.STAR_LIGHT, b -> b.withShape(" I ", "PDP", " G ").withIngredient('P', (TagKey<Item>)Tags.Items.GLASS_PANES_WHITE).withIngredient('G', (TagKey<Item>)Tags.Items.NUGGETS_GOLD));
    }

    private static GenericRecipe createIcicleLights(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, ICICLE_LIGHTS, FLItems.ICICLE_LIGHTS, b -> b.withShape(" I ", "GDG", " B ").withIngredient('G', (TagKey<Item>)Tags.Items.GLASS_PANES_COLORLESS).withIngredient('B', Items.f_42447_));
    }

    private static GenericRecipe createMeteorLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return FLCraftingRecipes.createLight(name, METEOR_LIGHT, FLItems.METEOR_LIGHT, b -> b.withShape(" I ", "GDG", "IPI").withIngredient('G', (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE).withIngredient('P', Items.f_42516_));
    }

    private static GenericRecipe createLight(ResourceLocation name, Supplier<? extends RecipeSerializer<GenericRecipe>> serializer, Supplier<? extends Item> variant, UnaryOperator<GenericRecipeBuilder> recipe) {
        return ((GenericRecipeBuilder)recipe.apply(new GenericRecipeBuilder(name, serializer))).withIngredient('I', (TagKey<Item>)Tags.Items.INGOTS_IRON).withIngredient('D', DYE_SUBTYPE_INGREDIENT).withOutput(variant.get(), 4).build();
    }

    private static class LightIngredient
    extends BasicAuxiliaryIngredient<ListTag> {
        private LightIngredient(boolean isRequired) {
            super(LazyTagIngredient.of(LIGHTS), isRequired, 8);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            CompoundTag compound = output.m_41783_();
            if (compound == null) {
                return ImmutableList.of();
            }
            ListTag pattern = compound.m_128437_("pattern", 10);
            if (pattern.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder lights = ImmutableList.builder();
            for (int i = 0; i < pattern.size(); ++i) {
                lights.add((Object)ImmutableList.of((Object)ItemStack.m_41712_((CompoundTag)pattern.m_128728_(i))));
            }
            return lights.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public ListTag accumulator() {
            return new ListTag();
        }

        @Override
        public void consume(ListTag patternList, ItemStack ingredient) {
            patternList.add((Object)ingredient.m_41739_(new CompoundTag()));
        }

        @Override
        public boolean finish(ListTag pattern, CompoundTag nbt) {
            if (pattern.size() > 0) {
                nbt.m_128365_("pattern", (Tag)pattern);
            }
            return false;
        }

        @Override
        public void addTooltip(List<Component> tooltip) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.hangingLights.light"));
        }
    }

    private static class PennantIngredient
    extends BasicAuxiliaryIngredient<ListTag> {
        private PennantIngredient() {
            super(LazyTagIngredient.of(PENNANTS), true, 8);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            CompoundTag compound = output.m_41783_();
            if (compound == null) {
                return ImmutableList.of();
            }
            ListTag pattern = compound.m_128437_("pattern", 10);
            if (pattern.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder pennants = ImmutableList.builder();
            for (int i = 0; i < pattern.size(); ++i) {
                pennants.add((Object)ImmutableList.of((Object)ItemStack.m_41712_((CompoundTag)pattern.m_128728_(i))));
            }
            return pennants.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public ListTag accumulator() {
            return new ListTag();
        }

        @Override
        public void consume(ListTag patternList, ItemStack ingredient) {
            patternList.add((Object)ingredient.m_41739_(new CompoundTag()));
        }

        @Override
        public boolean finish(ListTag pattern, CompoundTag nbt) {
            if (pattern.size() > 0) {
                nbt.m_128365_("pattern", (Tag)pattern);
                nbt.m_128365_("text", (Tag)StyledString.serialize(new StyledString()));
            }
            return false;
        }

        @Override
        public void addTooltip(List<Component> tooltip) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.pennantBunting.pennant"));
        }
    }
}

