/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util;

import java.util.NoSuchElementException;
import net.minecraft.world.phys.Vec3;

public interface Curve {
    public int getCount();

    public float getX();

    public float getY();

    public float getZ();

    public float getX(int var1);

    public float getX(int var1, float var2);

    public float getY(int var1);

    public float getY(int var1, float var2);

    public float getZ(int var1);

    public float getZ(int var1, float var2);

    public float getDx(int var1);

    public float getDy(int var1);

    public float getDz(int var1);

    public float getLength();

    default public SegmentIterator iterator() {
        return this.iterator(false);
    }

    public Curve lerp(Curve var1, float var2);

    default public void visitPoints(float spacing, boolean center, PointVisitor visitor) {
        float distance = center ? (this.getLength() % spacing + spacing) / 2.0f : 0.0f;
        int index = 0;
        SegmentIterator it = this.iterator();
        while (it.next()) {
            float length = it.getLength();
            while (distance < length) {
                float t = distance / length;
                visitor.visit(index++, it.getX(t), it.getY(t), it.getZ(t), it.getYaw(), it.getPitch());
                distance += spacing;
            }
            distance -= length;
            if (center || it.hasNext()) continue;
            visitor.visit(index++, it.getX(1.0f), it.getY(1.0f), it.getZ(1.0f), it.getYaw(), it.getPitch());
        }
    }

    public SegmentIterator iterator(boolean var1);

    public static interface SegmentIterator
    extends SegmentView {
        public boolean hasNext();

        public boolean next();
    }

    public static interface PointVisitor {
        public void visit(int var1, float var2, float var3, float var4, float var5, float var6);
    }

    public static abstract class CurveSegmentIterator<C extends Curve>
    implements SegmentIterator {
        protected final C curve;
        protected final boolean inclusive;
        protected final int count;
        protected int index;

        public CurveSegmentIterator(C curve, boolean inclusive) {
            this.curve = curve;
            this.inclusive = inclusive;
            this.count = curve.getCount();
            this.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 + (this.inclusive ? 0 : 1) < this.count;
        }

        @Override
        public boolean next() {
            int nextIndex = this.index + 1;
            if (this.inclusive ? nextIndex > this.count : nextIndex >= this.count) {
                throw new NoSuchElementException();
            }
            this.index = nextIndex;
            return nextIndex + (this.inclusive ? 0 : 1) < this.count;
        }

        protected void checkIndex(float t) {
            if (this.index + (this.inclusive && t == 0.0f ? 0 : 1) >= this.count) {
                throw new IllegalStateException();
            }
        }

        @Override
        public int getIndex() {
            this.checkIndex(0.0f);
            return this.index;
        }

        @Override
        public float getX(float t) {
            this.checkIndex(t);
            if (t == 0.0f) {
                return this.curve.getX(this.index);
            }
            if (t == 1.0f) {
                return this.curve.getX(this.index + 1);
            }
            return this.curve.getX(this.index, t);
        }

        @Override
        public float getY(float t) {
            this.checkIndex(t);
            if (t == 0.0f) {
                return this.curve.getY(this.index);
            }
            if (t == 1.0f) {
                return this.curve.getY(this.index + 1);
            }
            return this.curve.getY(this.index, t);
        }

        @Override
        public float getZ(float t) {
            this.checkIndex(t);
            if (t == 0.0f) {
                return this.curve.getZ(this.index);
            }
            if (t == 1.0f) {
                return this.curve.getZ(this.index);
            }
            return this.curve.getZ(this.index, t);
        }

        @Override
        public Vec3 getPos() {
            return new Vec3((double)this.curve.getX(this.index), (double)this.curve.getY(this.index), (double)this.curve.getZ(this.index));
        }

        @Override
        public abstract float getYaw();

        @Override
        public float getPitch() {
            this.checkIndex(1.0f);
            if (this.inclusive) {
                throw new IllegalStateException();
            }
            return this.getPitch(this.index);
        }

        protected abstract float getPitch(int var1);

        @Override
        public float getLength() {
            this.checkIndex(1.0f);
            if (this.inclusive) {
                throw new IllegalStateException();
            }
            return this.getLength(this.index);
        }

        protected abstract float getLength(int var1);
    }

    public static interface SegmentView {
        public int getIndex();

        public float getX(float var1);

        public float getY(float var1);

        public float getZ(float var1);

        public Vec3 getPos();

        public float getYaw();

        public float getPitch();

        public float getLength();
    }
}

