/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.monster_yam;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.common.entity.rotten_zombie.RottenZombieEntity;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class MonsterYamEntity
extends Monster {
    private int summonCooldown = 0;
    private int summonTimer = 0;
    private boolean isSummoning = false;

    public MonsterYamEntity(EntityType<? extends MonsterYamEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RotCropGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22278_, 0.2);
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                int duration = 6;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    duration = 8;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    duration = 12;
                }
                living.m_147207_(new MobEffectInstance((MobEffect)DDEffects.PUTRID_SCENT.get(), duration * 20, 0), (Entity)this);
            }
            return true;
        }
        return false;
    }

    public boolean isSummoning() {
        return this.isSummoning;
    }

    public void setSummoning(boolean summoning) {
        this.isSummoning = summoning;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.summonCooldown > 0) {
                --this.summonCooldown;
            }
            List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(6.0), Entity::m_6084_);
            for (LivingEntity livingEntity : list) {
                if (!livingEntity.m_6084_() || !livingEntity.m_6336_().equals(MobType.f_21641_)) continue;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 20, 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, 0));
            }
            if (this.m_5448_() instanceof Player && this.summonCooldown == 0) {
                if (!this.isSummoning()) {
                    this.setSummoning(true);
                    this.summonTimer = 40;
                    this.m_20334_(0.0, 0.0, 0.0);
                } else {
                    --this.summonTimer;
                    this.m_20334_(0.0, 0.0, 0.0);
                    if (this.summonTimer <= 0) {
                        List nearbyZombies = this.m_9236_().m_45976_(RottenZombieEntity.class, this.m_20191_().m_82400_(24.0));
                        if (nearbyZombies.isEmpty()) {
                            for (int i = 0; i < 3; ++i) {
                                RottenZombieEntity zombie = (RottenZombieEntity)((EntityType)DDEntities.ROTTEN_ZOMBIE.get()).m_20615_(this.m_9236_());
                                if (zombie == null) continue;
                                BlockPos spawnPos = this.m_20183_().m_7918_((int)((this.f_19796_.m_188500_() - 0.5) * 4.0), 0, (int)((this.f_19796_.m_188500_() - 0.5) * 4.0));
                                zombie.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                                this.m_9236_().m_7967_((Entity)zombie);
                                if (this.m_9236_().m_46791_() != Difficulty.HARD) continue;
                                this.m_9236_().m_7967_((Entity)zombie);
                            }
                            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)DDParticles.LIVING_FLAME.get()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
                        }
                        this.setSummoning(false);
                        this.summonCooldown = 600;
                    }
                }
            } else if (this.isSummoning()) {
                this.setSummoning(false);
                this.summonTimer = 0;
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        Entity entity;
        if (this.isSummoning()) {
            this.setSummoning(false);
            this.summonTimer = 0;
            this.summonCooldown = 400;
        }
        if ((entity = source.m_7639_()) instanceof Player && ((player = (Player)entity).m_21205_().m_204117_(ItemTags.f_271298_) || player.m_21205_().m_204117_(ModTags.KNIVES))) {
            amount *= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DDSounds.MONSTER_YAM_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)DDSounds.MONSTER_YAM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DDSounds.MONSTER_YAM_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)DDSounds.MONSTER_YAM_STEP.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public static class RotCropGoal
    extends Goal {
        private final MonsterYamEntity entity;
        private final double speed;
        private BlockPos targetCrop;

        public RotCropGoal(MonsterYamEntity entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            BlockPos entityPos = this.entity.m_20183_();
            if (!this.shouldSearch()) {
                return false;
            }
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)entityPos.m_7918_(-5, -1, -5), (BlockPos)entityPos.m_7918_(5, 1, 5))) {
                BlockState state = this.entity.m_9236_().m_8055_(pos);
                if (!this.canCropRot(state) || this.entity.m_21573_().m_7864_(pos, 0) == null) continue;
                this.targetCrop = pos.m_7949_();
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.targetCrop != null && !this.entity.m_21573_().m_26571_();
        }

        public void m_8056_() {
            if (this.targetCrop != null) {
                this.entity.m_21573_().m_26519_((double)this.targetCrop.m_123341_() + 0.5, (double)this.targetCrop.m_123342_(), (double)this.targetCrop.m_123343_() + 0.5, this.speed);
            }
        }

        public void m_8037_() {
            Vec3 targetVec;
            if (this.targetCrop != null && this.entity.m_20238_(targetVec = Vec3.m_82512_((Vec3i)this.targetCrop)) < 2.25) {
                if (this.canCropRot(this.entity.m_9236_().m_8055_(this.targetCrop))) {
                    this.rotCrop(this.targetCrop);
                }
                this.targetCrop = null;
            }
        }

        private boolean shouldSearch() {
            return this.entity.m_217043_().m_188503_(20) == 0;
        }

        private boolean canCropRot(BlockState state) {
            Block block = state.m_60734_();
            if (!(block instanceof CropBlock)) {
                return false;
            }
            CropBlock cropBlock = (CropBlock)block;
            if (!cropBlock.m_52307_(state)) {
                return false;
            }
            if (cropBlock instanceof TomatoVineBlock) {
                return (Boolean)state.m_61143_((Property)TomatoVineBlock.ROPELOGGED) == false;
            }
            return true;
        }

        private void rotCrop(BlockPos pos) {
            Level level = this.entity.m_9236_();
            BlockState oldState = level.m_8055_(pos);
            BlockState newState = ((Block)DDBlocks.ROTTEN_CROP.get()).m_49966_();
            if (oldState.m_60734_() instanceof PotatoBlock) {
                newState = ((Block)DDBlocks.ROTTEN_POTATOES.get()).m_49966_();
            } else if (oldState.m_60734_() instanceof TomatoVineBlock) {
                newState = ((Block)DDBlocks.ROTTEN_TOMATOES.get()).m_49966_();
            }
            level.m_46597_(pos, newState);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, oldState), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, 0.3, 0.3, 0.3, 0.05);
            }
            level.m_5594_(null, pos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

