/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.yirmiri.dungeonsdelight.common.item.EXPFoodItem;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class EXPCandiedFoodItem
extends EXPFoodItem {
    private final boolean hasFoodEffectTooltip;
    private final boolean hasCustomTooltip;
    private final boolean smallFood;

    public EXPCandiedFoodItem(Item.Properties properties, int experience, boolean hasFoodEffectTooltip, boolean hasCustomTooltip, boolean smallFood) {
        super(properties, experience, hasFoodEffectTooltip);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.hasCustomTooltip = hasCustomTooltip;
        this.smallFood = smallFood;
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        super.m_5922_(stack, level, living);
        if (!level.f_46443_ && living instanceof Player) {
            Player player = (Player)living;
            player.m_216990_(SoundEvents.f_215740_);
            if (this.smallFood) {
                player.m_5634_(2.0f);
            } else {
                player.m_5634_(4.0f);
            }
        }
        return stack;
    }

    @Override
    public int m_8105_(ItemStack stack) {
        if (this.smallFood) {
            return 32;
        }
        return 64;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.hasCustomTooltip) {
                MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + this), (Object[])new Object[0]);
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip, (float)1.0f);
            }
        }
    }
}

