/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.api.event;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;
import whocraft.tardis_refined.api.event.Event;
import whocraft.tardis_refined.api.event.EventResult;
import whocraft.tardis_refined.api.event.ShellChangeSource;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.control.Control;

public class TardisCommonEvents {
    public static final Event<TakeOff> TAKE_OFF = new Event<TakeOff>(TakeOff.class, listeners -> (tardisLevelOperator, level, pos) -> Event.result(listeners, takeOff -> takeOff.onTakeOff(tardisLevelOperator, level, pos)));
    public static final Event<Land> LAND = new Event<Land>(Land.class, listeners -> (tardisLevelOperator, level, pos) -> {
        for (Land listener : listeners) {
            listener.onLand(tardisLevelOperator, level, pos);
        }
    });
    public static final Event<TardisEntry> TARDIS_ENTRY_EVENT = new Event<TardisEntry>(TardisEntry.class, listeners -> (tardisLevelOperator, livingEntity, source, destination) -> {
        for (TardisEntry listener : listeners) {
            listener.onEnterTardis(tardisLevelOperator, livingEntity, source, destination);
        }
    });
    public static final Event<TardisExit> TARDIS_EXIT_EVENT = new Event<TardisExit>(TardisExit.class, listeners -> (tardisLevelOperator, livingEntity, source, destination) -> {
        for (TardisExit listener : listeners) {
            listener.onExitTardis(tardisLevelOperator, livingEntity, source, destination);
        }
    });
    public static final Event<CloseDoor> DOOR_CLOSED_EVENT = new Event<CloseDoor>(CloseDoor.class, listeners -> tardisLevelOperator -> {
        for (CloseDoor listener : listeners) {
            listener.onDoorClosed(tardisLevelOperator);
        }
    });
    public static final Event<OpenDoor> DOOR_OPENED_EVENT = new Event<OpenDoor>(OpenDoor.class, listeners -> tardisLevelOperator -> {
        for (OpenDoor listener : listeners) {
            listener.onDoorOpen(tardisLevelOperator);
        }
    });
    public static final Event<LockDoor> DOOR_LOCKED_EVENT = new Event<LockDoor>(LockDoor.class, listeners -> tardisLevelOperator -> {
        for (LockDoor listener : listeners) {
            listener.onDoorLocked(tardisLevelOperator);
        }
    });
    public static final Event<UnlockDoor> DOOR_UNLOCKED_EVENT = new Event<UnlockDoor>(UnlockDoor.class, listeners -> tardisLevelOperator -> {
        for (UnlockDoor listener : listeners) {
            listener.onDoorUnlocked(tardisLevelOperator);
        }
    });
    public static final Event<ShellChange> SHELL_CHANGE_EVENT = new Event<ShellChange>(ShellChange.class, listeners -> (tardisLevelOperator, theme, shellChangeSource) -> {
        for (ShellChange listener : listeners) {
            listener.onShellChange(tardisLevelOperator, theme, shellChangeSource);
        }
    });
    public static final Event<DesktopChangeEvent> DESKTOP_CHANGE_EVENT = new Event<DesktopChangeEvent>(DesktopChangeEvent.class, listeners -> tardisLevelOperator -> {
        for (DesktopChangeEvent listener : listeners) {
            listener.onDesktopChange(tardisLevelOperator);
        }
    });
    public static final Event<TardisCrash> TARDIS_CRASH_EVENT = new Event<TardisCrash>(TardisCrash.class, listeners -> (tardisLevelOperator, crashLocation) -> {
        for (TardisCrash listener : listeners) {
            listener.onTardisCrash(tardisLevelOperator, crashLocation);
        }
    });
    public static final Event<UpgradeUnlocked> UPGRADE_UNLOCKED = new Event<UpgradeUnlocked>(UpgradeUnlocked.class, listeners -> (tardisLevelOperator, upgrade) -> {
        for (UpgradeUnlocked listener : listeners) {
            listener.onUpgradeUnlock(tardisLevelOperator, upgrade);
        }
    });
    public static final Event<CanControlBeUsed> PLAYER_CONTROL_INTERACT = new Event<CanControlBeUsed>(CanControlBeUsed.class, listeners -> (tardisLevelOperator, control, controlEntity) -> Event.result(listeners, takeOff -> takeOff.canControlBeUsed(tardisLevelOperator, control, controlEntity)));

    @FunctionalInterface
    public static interface CanControlBeUsed {
        public EventResult canControlBeUsed(TardisLevelOperator var1, Control var2, ControlEntity var3);
    }

    @FunctionalInterface
    public static interface UpgradeUnlocked {
        public void onUpgradeUnlock(TardisLevelOperator var1, Upgrade var2);
    }

    @FunctionalInterface
    public static interface TardisCrash {
        public void onTardisCrash(TardisLevelOperator var1, TardisNavLocation var2);
    }

    @FunctionalInterface
    public static interface DesktopChangeEvent {
        public void onDesktopChange(TardisLevelOperator var1);
    }

    @FunctionalInterface
    public static interface ShellChange {
        public void onShellChange(TardisLevelOperator var1, ResourceLocation var2, ShellChangeSource var3);
    }

    @FunctionalInterface
    public static interface UnlockDoor {
        public void onDoorUnlocked(TardisLevelOperator var1);
    }

    @FunctionalInterface
    public static interface LockDoor {
        public void onDoorLocked(TardisLevelOperator var1);
    }

    @FunctionalInterface
    public static interface OpenDoor {
        public void onDoorOpen(TardisLevelOperator var1);
    }

    @FunctionalInterface
    public static interface CloseDoor {
        public void onDoorClosed(TardisLevelOperator var1);
    }

    @FunctionalInterface
    public static interface TardisExit {
        public void onExitTardis(TardisLevelOperator var1, LivingEntity var2, TardisNavLocation var3, TardisNavLocation var4);
    }

    @FunctionalInterface
    public static interface TardisEntry {
        public void onEnterTardis(TardisLevelOperator var1, LivingEntity var2, TardisNavLocation var3, TardisNavLocation var4);
    }

    @FunctionalInterface
    public static interface Land {
        public void onLand(TardisLevelOperator var1, LevelAccessor var2, BlockPos var3);
    }

    @FunctionalInterface
    public static interface TakeOff {
        public EventResult onTakeOff(TardisLevelOperator var1, LevelAccessor var2, BlockPos var3);
    }
}

