/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer.vortex;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.renderer.RenderHelper;
import whocraft.tardis_refined.common.VortexRegistry;
import whocraft.tardis_refined.common.capability.player.TardisPlayerInfo;

public class VortexRenderer {
    private static final RandomSource RAND = RandomSource.m_216327_();
    public VortexRegistry vortexType;
    public final RenderHelper.DynamicTimeKeep time = new RenderHelper.DynamicTimeKeep(2.0);
    private final List<VortexQuad> vortex_quads = new ArrayList<VortexQuad>();
    public float opacity = 1.0f;
    public float lightning_strike = 0.0f;

    public VortexRenderer(VortexRegistry type) {
        this.vortexType = type;
    }

    public void renderVortex(PoseStack pose, float opacity, boolean half) {
        int row;
        this.opacity = Math.min(opacity, 1.0f);
        if (this.vortexType.isMovingGradient()) {
            this.vortexType.getGradient().offset = this.time.getFloat() * 2.0f;
        }
        this.time.update();
        pose.m_85836_();
        RenderHelper.rotateZYX(pose, 90.0f, 180.0f, 0.0f);
        pose.m_252880_(0.0f, 1.0f, 0.0f);
        pose.m_85841_(1.0f, (float)this.vortexType.getRows(), 1.0f);
        int n = row = half ? 0 : -this.vortexType.getRows();
        while (row < this.vortexType.getRows()) {
            Tesselator tesselator = this.beginTextureColor(VertexFormat.Mode.TRIANGLE_STRIP);
            pose.m_85836_();
            pose.m_252880_(0.0f, this.o(row), 0.0f);
            RenderHelper.rotateZYX(pose, 0.0f, (float)row * this.vortexType.getTwist(), 0.0f);
            this.renderCylinder(pose, row);
            pose.m_85849_();
            tesselator.m_85914_();
            ++row;
        }
        if (this.vortexType.hasDecals()) {
            Tesselator tesselator = this.beginTextureColor(VertexFormat.Mode.QUADS);
            int i = 0;
            while ((float)i < (float)this.vortexType.getRows() / 2.0f) {
                if (this.vortex_quads.size() < i + 1) {
                    this.vortex_quads.add(new VortexQuad());
                    break;
                }
                pose.m_85836_();
                this.vortex_quads.get(i).renderQuad(pose, this.time, this.vortexType, (float)i / ((float)this.vortexType.getRows() / 2.0f), this.opacity);
                this.lightning_strike += this.vortex_quads.get((int)i).lightning_strike * this.vortex_quads.get((int)i).lightning_strike / ((float)this.vortexType.getRows() / 2.0f);
                pose.m_85849_();
                ++i;
            }
            tesselator.m_85914_();
        }
        this.lightning_strike *= 0.9f;
        pose.m_85849_();
    }

    public void renderVortex(GuiGraphics guiGraphics, float opacity, boolean half) {
        PoseStack pose = guiGraphics.m_280168_();
        this.renderVortex(pose, opacity, half);
    }

    public void renderVortex(GuiGraphics guiGraphics, float opacity) {
        this.renderVortex(guiGraphics, opacity, false);
    }

    private void renderCylinder(PoseStack poseStack, int row) {
        float length = 1.0f / (float)this.vortexType.getRows();
        float oA = this.o(row + 1);
        float oB = this.o(row);
        float radiusA = VortexRenderer.wobbleRadius(oA);
        float radiusB = VortexRenderer.wobbleRadius(oB);
        for (int s = 0; s <= this.vortexType.getSides(); ++s) {
            float angle = (float)Math.PI * 2 * (float)s / (float)this.vortexType.getSides();
            float xA = radiusA * Mth.m_14089_((float)angle);
            float zA = radiusA * Mth.m_14031_((float)angle);
            xA += VortexRenderer.xWobble(oA, (float)this.time.speed) * Mth.m_14031_((float)oA);
            zA += VortexRenderer.zWobble(oA, (float)this.time.speed) * Mth.m_14031_((float)oA);
            float xB = radiusB * Mth.m_14089_((float)angle);
            float zB = radiusB * Mth.m_14031_((float)angle);
            xB += VortexRenderer.xWobble(oB, (float)this.time.speed) * Mth.m_14031_((float)oB);
            zB += VortexRenderer.zWobble(oB, (float)this.time.speed) * Mth.m_14031_((float)oB);
            float u = (float)s / (float)this.vortexType.getSides() * 0.5f;
            float timeOffset = this.time.getFloat();
            float uvOffset = length * (float)row;
            float vA = length + uvOffset + timeOffset;
            float vB = 0.0f + uvOffset + timeOffset;
            float bA = VortexRenderer.radiusFunc(oA);
            float bB = VortexRenderer.radiusFunc(oB);
            this.vertexUVColor(poseStack, xA, length, zA, u, vA, bA, bA, bA, 1.0f, oA);
            RenderHelper.rotateZYX(poseStack, 0.0f, -this.vortexType.getTwist(), 0.0f);
            this.vertexUVColor(poseStack, xB, 0.0f, zB, u, vB, bB, bB, bB, 1.0f, oB);
            RenderHelper.rotateZYX(poseStack, 0.0f, this.vortexType.getTwist(), 0.0f);
        }
    }

    private Tesselator beginTextureColor(VertexFormat.Mode mode) {
        return RenderHelper.beginTextureColor(this.vortexType.getTexture(), mode, false);
    }

    private void vertexUVColor(@NotNull PoseStack pose, float x, float y, float z, float u, float v, float r, float g, float b, float a, float o) {
        float[] color = this.vortexType.getGradient().getRGBf(o);
        RenderHelper.vertexUVColor(pose, x, y, z, u, v, r * color[0], g * color[1], b * color[2], a * this.opacity);
    }

    private static float timingWithOffset(float speed, float offset) {
        long long_speed = (long)(speed * 1000.0f);
        long time = System.currentTimeMillis() + (long)(1000.0f * offset);
        try {
            return (float)(time % long_speed) / (speed * 1000.0f);
        }
        catch (Exception e) {
            return 1.0f;
        }
    }

    private static float timing(float speed) {
        return VortexRenderer.timingWithOffset(speed, 0.0f);
    }

    private float o(int row) {
        return (float)row / (float)this.vortexType.getRows();
    }

    private static float radiusFunc(float o) {
        return -(o * o) + 1.0f;
    }

    private static float wobbleRadius(float o) {
        return VortexRenderer.radiusFunc(o) * (1.0f + 0.05f * Mth.m_14031_((float)((float)Math.PI * 2 * (o + VortexRenderer.timing(687.0f)))) * Mth.m_14031_((float)((float)Math.PI * 2 * (o + VortexRenderer.timing(9852.0f)))));
    }

    private static float xWobble(float o, float SPEED) {
        return (Mth.m_14031_((float)(o * 1.0f + VortexRenderer.timing(1.999f) * 2.0f * (float)Math.PI)) + Mth.m_14031_((float)(o * 0.5f + VortexRenderer.timing(3.778f) * 2.0f * (float)Math.PI))) * SPEED * 2.0f;
    }

    private static float zWobble(float o, float SPEED) {
        return (Mth.m_14089_((float)(o * 1.0f + VortexRenderer.timing(2.256f) * 2.0f * (float)Math.PI)) + Mth.m_14089_((float)(o * 0.5f + VortexRenderer.timing(3.271f) * 2.0f * (float)Math.PI))) * SPEED * 2.0f;
    }

    private static class VortexQuad {
        public boolean valid = true;
        public boolean lightning = false;
        private float prev_tO = -1.0f;
        private float u = 0.0f;
        private float v = 0.0f;
        private final float uvSize = 0.125f;
        private float lightning_a;
        public float lightning_strike = 0.0f;

        private void rndQuad(VortexRegistry vortexType) {
            this.valid = true;
            this.prev_tO = 1.0f;
            this.rndUV();
            this.lightning = RAND.m_188499_() && vortexType.hasLightning();
        }

        private void rndUV() {
            this.u = (float)RAND.m_216332_(0, 3) * 0.125f;
            this.v = (float)RAND.m_216332_(0, 3) * 0.125f;
        }

        public void renderQuad(PoseStack poseStack, RenderHelper.DynamicTimeKeep time, VortexRegistry vortexType, float time_offset, float opacity) {
            float tO;
            if (!this.valid) {
                this.rndQuad(vortexType);
            }
            if ((tO = -(time.getFloat(time_offset) * 2.0f) - 1.0f) > this.prev_tO || !this.valid) {
                this.valid = false;
                return;
            }
            if (this.lightning && System.currentTimeMillis() % 5L == 0L && this.lightning && Math.random() > (double)0.95f) {
                this.lightning_a = 3.0f;
                if (tO > 0.0f) {
                    this.lightning_strike = opacity * (1.0f - Mth.m_14154_((float)(tO * tO)));
                }
                TardisPlayerInfo.get((LivingEntity)Minecraft.m_91087_().f_91074_).ifPresent(tardisPlayerInfo -> {
                    if (!tardisPlayerInfo.isViewingTardis()) {
                        return;
                    }
                    if (!tardisPlayerInfo.isRenderVortex()) {
                        return;
                    }
                    assert (Minecraft.m_91087_().f_91074_ != null);
                    Minecraft.m_91087_().f_91074_.m_5496_(RAND.m_188499_() ? SoundEvents.f_12089_ : SoundEvents.f_12090_, opacity * (1.0f - Mth.m_14154_((float)(tO * tO))) * 0.5f, (float)(Math.random() * (double)(1.0f - Mth.m_14154_((float)tO))));
                });
                this.rndUV();
            }
            float u0 = 0.5f + this.u;
            float v0 = this.v + (this.lightning ? 0.5f : 0.0f);
            float u1 = u0 + 0.125f;
            float v1 = v0 + 0.125f;
            float x = VortexRenderer.xWobble(tO, (float)time.speed) * Mth.m_14031_((float)tO);
            float z = VortexRenderer.zWobble(tO, (float)time.speed) * Mth.m_14031_((float)tO);
            float s = VortexRenderer.wobbleRadius(tO);
            float val = this.lightning ? 1.0f : VortexRenderer.radiusFunc(tO);
            float alpha = this.lightning ? this.lightning_a : val;
            alpha = Math.min(alpha, 1.0f);
            poseStack.m_85836_();
            RenderHelper.rotateZYX(poseStack, 0.0f, -vortexType.getTwist(), 0.0f);
            RenderHelper.rotateZYX(poseStack, 0.0f, tO * (float)vortexType.getRows() * vortexType.getTwist(), 0.0f);
            this.vertexUVColor(poseStack, x - s, tO, z + s, u0, v1, val, alpha *= opacity, tO, !this.lightning, vortexType);
            this.vertexUVColor(poseStack, x + s, tO, z + s, u1, v1, val, alpha, tO, !this.lightning, vortexType);
            this.vertexUVColor(poseStack, x + s, tO, z - s, u1, v0, val, alpha, tO, !this.lightning, vortexType);
            this.vertexUVColor(poseStack, x - s, tO, z - s, u0, v0, val, alpha, tO, !this.lightning, vortexType);
            poseStack.m_85849_();
            this.prev_tO = tO;
            this.lightning_a *= 0.9f;
            this.lightning_strike *= 0.9f;
        }

        private void vertexUVColor(@NotNull PoseStack pose, float x, float y, float z, float u, float v, float val, float a, float o, boolean tint, VortexRegistry vortexType) {
            float[] color = vortexType.getGradient().getRGBf(o);
            if (tint) {
                RenderHelper.vertexUVColor(pose, x, y, z, u, v, val * color[0], val * color[1], val * color[2], a);
            } else {
                RenderHelper.vertexUVColor(pose, x, y, z, u, v, val, val, val, a);
            }
        }
    }
}

