/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.main;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.screen.ScreenHelper;
import whocraft.tardis_refined.client.screen.components.BackgroundlessButton;
import whocraft.tardis_refined.client.screen.components.GenericMonitorSelectionList;
import whocraft.tardis_refined.client.screen.components.SelectionListEntry;
import whocraft.tardis_refined.client.screen.main.MonitorOS;
import whocraft.tardis_refined.client.screen.screens.DesktopSelectionScreen;
import whocraft.tardis_refined.client.screen.screens.HumSelectionScreen;
import whocraft.tardis_refined.client.screen.screens.VortexSelectionScreen;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.network.messages.C2SEjectPlayer;
import whocraft.tardis_refined.common.network.messages.player.C2SBeginShellView;
import whocraft.tardis_refined.common.network.messages.screens.C2SRequestShellSelection;
import whocraft.tardis_refined.common.network.messages.waypoints.C2SRequestWaypoints;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.patterns.ShellPatterns;
import whocraft.tardis_refined.registry.TRUpgrades;

public class MonitorScreen
extends MonitorOS.MonitorOSExtension {
    private final TardisNavLocation currentLocation;
    private final TardisNavLocation targetLocation;
    private final UpgradeHandler upgradeHandler;
    private boolean noUpgrades = false;
    private Button ejectbtn;
    private int ejectbtntime;
    private boolean ejectbtnshow;

    public MonitorScreen(TardisNavLocation currentLocation, TardisNavLocation targetLocation, UpgradeHandler upgradeHandler, ResourceLocation currentShellTheme) {
        super((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_MAIN_TITLE), currentShellTheme);
        this.currentLocation = currentLocation;
        this.targetLocation = targetLocation;
        this.upgradeHandler = upgradeHandler;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        BackgroundlessButton extView = (BackgroundlessButton)this.m_142416_((GuiEventListener)BackgroundlessButton.backgroundlessBuilder((Component)Component.m_237113_((String)""), button -> {
            new C2SBeginShellView().send();
            Minecraft.m_91087_().m_91152_(null);
        }).pos(hPos + 20, -30 + this.f_96544_ / 2).size(40, 60).build());
        extView.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_SHELL_VIEW)));
        extView.f_93623_ = true;
        this.ejectbtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_EJECT), button -> {
            new C2SEjectPlayer().send();
            Minecraft.m_91087_().m_91152_(null);
        }).m_252794_(-35 + hPos + 115, vPos + 130 - 20).m_253046_(70, 20).m_253136_());
    }

    @Override
    public void renderBackdrop(@NotNull GuiGraphics guiGraphics) {
        super.renderBackdrop(guiGraphics);
        PoseStack poseStack = guiGraphics.m_280168_();
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        poseStack.m_85836_();
        int b = this.f_96544_ - vPos;
        int r = this.f_96543_ - hPos;
        int l1 = hPos + 46;
        int l2 = (int)((float)hPos + 92.0f);
        guiGraphics.m_280509_(l1, vPos, r, b, -1072689136);
        poseStack.m_252880_((float)l1, (float)vPos, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        guiGraphics.m_280024_(0, 0, 130, l1 - hPos, -1072689136, 0);
        poseStack.m_85849_();
    }

    @Override
    public void inMonitorRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int upgradesLeftPos = this.f_96543_ / 2 - 75;
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        this.ejectbtnshow = mouseY >= vPos + 130 - 20 && mouseY <= vPos + 130 && mouseX >= -35 + hPos + 115 && mouseX <= 35 + hPos + 115;
        this.ejectbtn.m_264152_(-35 + hPos + 115, vPos + 130 - this.ejectbtntime);
        boolean bl = this.ejectbtn.f_93623_ = this.ejectbtntime == 20;
        if (this.noUpgrades && ChatFormatting.GOLD.m_126665_() != null) {
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, Component.m_237115_((String)ModMessages.UI_NO_INSTALLED_SUBSYSTEMS).getString(), upgradesLeftPos, vPos + 30, ChatFormatting.GOLD.m_126665_().intValue());
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 1000.0f);
        this.renderShell(guiGraphics, hPos + 40, -1 + this.f_96544_ / 2, 15.0f);
        poseStack.m_85849_();
        int textScale = 40;
        poseStack.m_85836_();
        poseStack.m_252880_((float)(hPos + 10), (float)(vPos + 10), 0.0f);
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, Component.m_237115_((String)ModMessages.UI_MONITOR_GPS).getString() + ":", 0, 0, Color.WHITE.getRGB());
        ScreenHelper.renderWidthScaledText(this.currentLocation.getDirection().m_122433_().toUpperCase() + " @ " + this.currentLocation.getPosition().m_123344_(), guiGraphics, Minecraft.m_91087_().f_91062_, 0.0f, 10.0f, Color.LIGHT_GRAY.getRGB(), textScale * 2, 0.75f, false);
        ScreenHelper.renderWidthScaledText(MiscHelper.getCleanDimensionName(this.currentLocation.getDimensionKey()), guiGraphics, Minecraft.m_91087_().f_91062_, 0.0f, 20.0f, Color.LIGHT_GRAY.getRGB(), textScale - 3, 1.5f, false);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(hPos + 10), (float)(vPos + 130 - 35), 0.0f);
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, Component.m_237115_((String)ModMessages.UI_MONITOR_DESTINATION).getString() + ":", 0, 0, Color.WHITE.getRGB());
        ScreenHelper.renderWidthScaledText(this.targetLocation.getDirection().m_122433_().toUpperCase() + " @ " + this.targetLocation.getPosition().m_123344_(), guiGraphics, Minecraft.m_91087_().f_91062_, 0.0f, 10.0f, Color.LIGHT_GRAY.getRGB(), textScale * 2, 0.75f, false);
        ScreenHelper.renderWidthScaledText(MiscHelper.getCleanDimensionName(this.targetLocation.getDimensionKey()), guiGraphics, Minecraft.m_91087_().f_91062_, 0.0f, 20.0f, Color.LIGHT_GRAY.getRGB(), textScale - 3, 1.5f, false);
        poseStack.m_85849_();
    }

    @Override
    public ResourceLocation getPatternForRender() {
        TardisClientData tardisClientData = TardisClientData.getInstance((ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
        if (tardisClientData == null) {
            return ShellPatterns.DEFAULT.id();
        }
        return tardisClientData.getShellPattern();
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.ejectbtntime = this.ejectbtnshow ? (this.ejectbtntime += 5 - this.ejectbtntime / 4) : (this.ejectbtntime -= 5 - (20 - this.ejectbtntime) / 4);
        if (this.ejectbtntime > 20) {
            this.ejectbtntime = 20;
        }
        if (this.ejectbtntime < 5) {
            this.ejectbtntime = 5;
        }
    }

    public GenericMonitorSelectionList<SelectionListEntry> createSelectionList() {
        int hPos = -20 + this.f_96543_ / 2;
        int vPos = 20 + (this.f_96544_ - 130) / 2;
        GenericMonitorSelectionList<SelectionListEntry> selectionList = new GenericMonitorSelectionList<SelectionListEntry>(this.f_96541_, 130, 80, hPos, vPos, this.f_96544_ - vPos, 12);
        selectionList.m_93488_(false);
        selectionList.m_6702_().add(new SelectionListEntry((Component)Component.m_237115_((String)ModMessages.UI_EXTERNAL_SHELL), entry -> new C2SRequestShellSelection().send(), hPos, TRUpgrades.CHAMELEON_CIRCUIT_SYSTEM.get().isUnlocked(this.upgradeHandler)));
        selectionList.m_6702_().add(new SelectionListEntry((Component)Component.m_237115_((String)ModMessages.UI_DESKTOP_CONFIGURATION), entry -> this.switchScreenToRight(new DesktopSelectionScreen()), hPos, TRUpgrades.INSIDE_ARCHITECTURE.get().isUnlocked(this.upgradeHandler)));
        selectionList.m_6702_().add(new SelectionListEntry((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_WAYPOINTS), entry -> new C2SRequestWaypoints().send(), hPos, TRUpgrades.WAYPOINTS.get().isUnlocked(this.upgradeHandler)));
        selectionList.m_6702_().add(new SelectionListEntry((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_VORTEX), entry -> this.switchScreenToRight(new VortexSelectionScreen(currentVortex)), hPos));
        selectionList.m_6702_().add(new SelectionListEntry((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_SELECT_HUM), entry -> this.switchScreenToRight(new HumSelectionScreen()), hPos));
        if (selectionList.m_6702_().isEmpty()) {
            this.noUpgrades = true;
            return null;
        }
        return selectionList;
    }
}

