/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.screen.components.GenericMonitorSelectionList;
import whocraft.tardis_refined.client.screen.components.SelectionListEntry;
import whocraft.tardis_refined.client.screen.main.MonitorOS;
import whocraft.tardis_refined.common.network.messages.C2SChangeDesktop;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class DesktopSelectionScreen
extends MonitorOS {
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/DesktopSelectionScreen");
    public static ResourceLocation previousImage = TardisDesktops.FACTORY_THEME.getPreviewTexture();
    private DesktopTheme currentDesktopTheme;

    public DesktopSelectionScreen() {
        super((Component)Component.m_237115_((String)ModMessages.UI_DESKTOP_CONFIGURATION), new ResourceLocation("tardis_refined", "textures/gui/monitor/backdrop.png"));
    }

    public static void selectDesktop(DesktopTheme theme) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        new C2SChangeDesktop((ResourceKey<Level>)Minecraft.m_91087_().f_91074_.m_9236_().m_46472_(), theme).send();
        Minecraft.m_91087_().m_91152_(null);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.setEvents(() -> DesktopSelectionScreen.selectDesktop(this.currentDesktopTheme), () -> {
            if (this.PREVIOUS != null) {
                this.switchScreenToLeft(this.PREVIOUS);
            }
        });
        this.currentDesktopTheme = this.grabDesktop();
        int vPos = (this.f_96544_ - 130) / 2;
        this.addSubmitButton(this.f_96543_ / 2 + 25, this.f_96544_ - vPos - 25);
        this.addCancelButton(this.f_96543_ / 2 + 5, this.f_96544_ - vPos - 25);
    }

    private DesktopTheme grabDesktop() {
        Iterator<DesktopTheme> iterator = TardisDesktops.getRegistry().values().iterator();
        if (iterator.hasNext()) {
            DesktopTheme desktop = iterator.next();
            return desktop;
        }
        return null;
    }

    @Override
    public void renderBackdrop(@NotNull GuiGraphics guiGraphics) {
        super.renderBackdrop(guiGraphics);
    }

    @Override
    public void inMonitorRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(this.backdrop, 5 + this.f_96543_ / 2, -50 + this.f_96544_ / 2, 110, 130, 110, 95);
        poseStack.m_85836_();
        int trim = 15;
        poseStack.m_252880_((float)(hPos + trim - 5), (float)(vPos + trim + 5), 0.0f);
        float scale = (float)(130 - 2 * trim) / 400.0f;
        guiGraphics.m_280218_(this.backdrop, -5, -5, 0, 130, 110, 110);
        poseStack.m_85841_(scale, scale, scale);
        guiGraphics.m_280163_(this.currentDesktopTheme.getPreviewTexture(), 0, 0, 0.0f, 0.0f, 400, 400, 400, 400);
        double alpha = (100.0 - (double)this.age * 3.0) / 100.0;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha));
        guiGraphics.m_280218_(previousImage, 0, 0, 400, 400, 400, 400);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NOISE);
        guiGraphics.m_280218_(NOISE, 0, 0, (int)(Math.random() * 736.0), (int)((double)(414L * (System.currentTimeMillis() % 1000L)) / 1000.0), 400, 400);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    @Override
    public ObjectSelectionList<SelectionListEntry> createSelectionList() {
        int leftPos = 5 + this.f_96543_ / 2;
        int topPos = (this.f_96544_ - 130) / 2;
        GenericMonitorSelectionList<SelectionListEntry> selectionList = new GenericMonitorSelectionList<SelectionListEntry>(this.f_96541_, 100, 80, leftPos, topPos + 15, topPos + 130 - 30, 12);
        selectionList.m_93488_(false);
        Collection<DesktopTheme> values = TardisDesktops.getRegistry().values();
        values = values.stream().sorted(Comparator.comparing(DesktopTheme::getName)).toList();
        for (DesktopTheme desktop : values) {
            MutableComponent name = Component.m_237113_((String)MiscHelper.getCleanName(desktop.getIdentifier().m_135815_()));
            try {
                name = Component.Serializer.m_130699_((StringReader)new StringReader(desktop.getName()));
            }
            catch (Exception ex) {
                LOGGER.error("Could not process Name for datapack desktop {}", (Object)desktop.getIdentifier().toString());
            }
            MutableComponent tooltip = Component.m_237113_((String)(ChatFormatting.BLUE + Platform.getModName(desktop.getIdentifier().m_135827_())));
            SelectionListEntry entry = new SelectionListEntry((Component)name, selectedEntry -> {
                previousImage = this.currentDesktopTheme.getPreviewTexture();
                this.currentDesktopTheme = desktop;
                for (Object child : selectionList.m_6702_()) {
                    if (!(child instanceof SelectionListEntry)) continue;
                    SelectionListEntry current = (SelectionListEntry)((Object)((Object)child));
                    current.setChecked(false);
                }
                selectedEntry.setChecked(true);
                this.age = 0;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)TRSoundRegistry.STATIC.get(), (float)((float)Math.random())));
            }, leftPos);
            entry.setTooltip((Component)tooltip);
            selectionList.m_6702_().add(entry);
        }
        return selectionList;
    }
}

