/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.blockentity.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.control.ControlSpecification;
import whocraft.tardis_refined.common.tardis.manager.TardisInteriorManager;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.LevelHelper;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.patterns.ConsolePattern;
import whocraft.tardis_refined.patterns.ConsolePatterns;
import whocraft.tardis_refined.registry.TRBlockEntityRegistry;
import whocraft.tardis_refined.registry.TRDamageSources;

public class GlobalConsoleBlockEntity
extends BlockEntity
implements BlockEntityTicker<GlobalConsoleBlockEntity> {
    private final List<ControlEntity> controlEntityList = new ArrayList<ControlEntity>();
    public AnimationState liveliness = new AnimationState();
    public AnimationState powerOff = new AnimationState();
    public AnimationState powerOn = new AnimationState();
    private boolean shouldSpawnControls = true;
    private ResourceLocation consoleTheme = ConsoleTheme.FACTORY.getId();
    private int ticksBooting = 0;
    private ConsolePattern basePattern = this.pattern();

    public int getTicksBooting() {
        return this.ticksBooting;
    }

    public void setTicksBooting(int ticksBooting) {
        this.ticksBooting = ticksBooting;
    }

    public GlobalConsoleBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TRBlockEntityRegistry.GLOBAL_CONSOLE_BLOCK.get(), blockPos, blockState);
    }

    public ResourceLocation theme() {
        if (this.consoleTheme == null) {
            this.consoleTheme = ConsoleTheme.FACTORY.getId();
        }
        return this.consoleTheme;
    }

    public void setConsoleTheme(ResourceLocation themeId) {
        this.consoleTheme = themeId;
        this.m_6596_();
        this.sendUpdates();
    }

    public ConsolePattern pattern() {
        return this.basePattern == null ? ConsolePatterns.DEFAULT : this.basePattern;
    }

    public List<ControlEntity> getControlEntityList() {
        return this.controlEntityList;
    }

    public GlobalConsoleBlockEntity setPattern(ConsolePattern basePattern) {
        this.basePattern = basePattern;
        this.m_6596_();
        this.sendUpdates();
        return this;
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (this.consoleTheme != null) {
            compoundTag.m_128359_("theme", this.consoleTheme.toString());
        }
        if (this.basePattern != null) {
            compoundTag.m_128359_("pattern", this.basePattern.id().toString());
        }
        compoundTag.m_128405_("ticks_booting", this.ticksBooting);
    }

    public void m_142466_(CompoundTag tag) {
        ConsoleTheme theme;
        boolean needsDataFixed = false;
        if (tag.m_128441_("ticks_booting")) {
            this.ticksBooting = tag.m_128451_("ticks_booting");
        }
        if (tag.m_128441_("theme")) {
            ResourceLocation themeId = new ResourceLocation(tag.m_128461_("theme"));
            theme = ConsoleTheme.CONSOLE_THEME_DEFERRED_REGISTRY.get(themeId);
            if (theme == null) {
                TardisRefined.LOGGER.info("The console theme: {} does not exist! Resetting Console Theme & Pattern at {}", (Object)themeId, (Object)this.m_58899_());
                needsDataFixed = true;
                this.consoleTheme = this.theme();
            } else {
                this.consoleTheme = themeId;
            }
        }
        if (tag.m_128441_("pattern") && !needsDataFixed) {
            ResourceLocation currentPattern = new ResourceLocation(tag.m_128461_("pattern"));
            theme = this.theme();
            if (ConsolePatterns.doesPatternExist((ResourceLocation)theme, currentPattern)) {
                this.basePattern = ConsolePatterns.getPatternOrDefault((ResourceLocation)theme, currentPattern);
            }
        }
        if (this.consoleTheme == null) {
            this.consoleTheme = this.theme();
        }
        if (this.basePattern == null || needsDataFixed) {
            this.basePattern = this.pattern();
        }
        super.m_142466_(tag);
        this.spawnControlEntities();
    }

    public void spawnControlEntities() {
        BlockPos currentBlockPos = this.m_58899_();
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.killControls();
            ResourceLocation themeId = this.theme();
            ConsoleTheme consoleTheme = ConsoleTheme.CONSOLE_THEME_DEFERRED_REGISTRY.get(themeId);
            ControlSpecification[] controls = consoleTheme.getControlSpecificationList();
            for (ControlSpecification control : Arrays.stream(controls).toList()) {
                ControlEntity controlEntity = new ControlEntity(this.m_58904_());
                controlEntity.setPosForDebug(control.offsetPosition());
                Vec3 location = LevelHelper.centerPos(currentBlockPos, true).m_82520_((double)control.offsetPosition().x(), (double)control.offsetPosition().y(), (double)control.offsetPosition().z());
                controlEntity.m_6034_(location.m_7096_(), location.m_7098_(), location.m_7094_());
                controlEntity.assignControlData(consoleTheme, control, this.m_58899_());
                serverLevel.m_7967_((Entity)controlEntity);
                this.controlEntityList.add(controlEntity);
            }
            this.shouldSpawnControls = false;
        }
    }

    public void markDirty() {
        this.shouldSpawnControls = true;
    }

    public void m_7651_() {
        super.m_7651_();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        this.f_58857_.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
        this.f_58857_.m_7260_(this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), this.f_58857_.m_8055_(this.m_58899_()), 2);
        this.m_6596_();
    }

    public void killControls() {
        this.controlEntityList.forEach(Entity::m_146870_);
        this.controlEntityList.clear();
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, GlobalConsoleBlockEntity blockEntity) {
        if (this.shouldSpawnControls && ((Boolean)blockState.m_61143_((Property)GlobalConsoleBlock.POWERED)).booleanValue()) {
            this.spawnControlEntities();
        }
        if (!this.liveliness.m_216984_()) {
            this.liveliness.m_216977_(12);
        }
        if (this.ticksBooting >= 1) {
            ++this.ticksBooting;
        }
        if (this.ticksBooting == 40) {
            this.ticksBooting = 0;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TardisLevelOperator.get(serverLevel).ifPresent(x -> {
                if (x.getPilotingManager().isInRecovery() && serverLevel.m_46467_() % 20L == 0L) {
                    List<Player> nearbyPlayers = TardisHelper.getPlayersInRange(level, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), 3.0);
                    nearbyPlayers.forEach(player -> player.m_6469_(TRDamageSources.getSource(serverLevel, TRDamageSources.CHOKE), 0.5f));
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_(), 120, 2.0, 1.0, 2.0, 0.005);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_(), 120, 2.0, 1.0, 2.0, 0.005);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_(), 120, 2.0, 1.0, 2.0, 0.01);
                }
                if (x.getLevel().m_46467_() % 20L == 0L) {
                    TardisInteriorManager intManager;
                    if (x.getPilotingManager().isCrashing() && x.getLevel().m_213780_().m_188503_(15) == 0) {
                        level.m_254849_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 2.0f, Level.ExplosionInteraction.NONE);
                    }
                    if ((intManager = x.getInteriorManager()).isCave()) {
                        intManager.setCurrentTheme(intManager.preparedTheme());
                    }
                }
            });
        }
    }
}

