/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.items;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.util.DimensionUtil;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;

public class DimensionSamplerItem
extends Item {
    private static final String POTENTIAL_DIM_TAG = "potentialDim";
    private static final String SAVED_DIM_TAG = "savedDim";
    private static final String TIMER_TAG = "timer";
    private static final int TIMER_MAX = 6000;

    public DimensionSamplerItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack forceColor(ItemStack itemStack, int color) {
        itemStack.m_41698_("display").m_128405_("color", color);
        return itemStack;
    }

    public int getColor(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41737_("display");
        return compoundTag != null && compoundTag.m_128425_("color", 99) ? compoundTag.m_128451_("color") : DyeColor.PINK.m_41071_();
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Player player = useOnContext.m_43723_();
        Level level = useOnContext.m_43725_();
        InteractionHand hand = useOnContext.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(POTENTIAL_DIM_TAG) && DimensionUtil.isAllowedDimension((ResourceKey<Level>)level.m_46472_())) {
                DimensionSamplerItem.forceColor(stack, serverLevel.m_6171_(useOnContext.m_8083_(), (biome, d, e) -> biome.m_47539_()));
                this.savePotentialDim(tag, (ResourceKey<Level>)serverLevel.m_46472_());
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237110_((String)ModMessages.DIM_POTENTIAL, (Object[])new Object[]{MiscHelper.getCleanDimensionName((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(SAVED_DIM_TAG))))}), true);
            } else {
                PlayerUtil.sendMessage((LivingEntity)player, !DimensionUtil.isAllowedDimension((ResourceKey<Level>)level.m_46472_()) ? ModMessages.DIM_NOT_ALLOWED : ModMessages.DIM_ALREADY_SAVED, true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                CompoundTag tag = itemStack.m_41784_();
                if (tag.m_128441_(POTENTIAL_DIM_TAG)) {
                    String potentialDim = tag.m_128461_(POTENTIAL_DIM_TAG);
                    ResourceKey currentDim = serverLevel.m_46472_();
                    if (currentDim.m_135782_().toString().equals(potentialDim)) {
                        int timer = tag.m_128451_(TIMER_TAG) + 1;
                        if (timer >= 6000) {
                            this.saveSavedDim(tag, potentialDim);
                        } else {
                            this.updateTimer(tag, timer);
                        }
                    } else {
                        this.resetProgress(tag);
                    }
                }
            }
        }
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.NONE;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TIMER_TAG) && tag.m_128441_(POTENTIAL_DIM_TAG)) {
            int timer = tag.m_128451_(TIMER_TAG);
            double progress = (double)timer / 6000.0 * 100.0;
            tooltip.add((Component)Component.m_237110_((String)ModMessages.TOOLTIP_DIM_PROGRESS, (Object[])new Object[]{Math.round(progress) + "%"}));
        } else if (tag != null && tag.m_128441_(SAVED_DIM_TAG)) {
            tooltip.add((Component)Component.m_237110_((String)ModMessages.TOOLTIP_DIM_SAVED, (Object[])new Object[]{MiscHelper.getCleanDimensionName((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(SAVED_DIM_TAG))))}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)ModMessages.TOOLTIP_NO_DIM_SAVED));
        }
    }

    public static boolean hasDimAtAll(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(POTENTIAL_DIM_TAG) || tag.m_128441_(SAVED_DIM_TAG);
    }

    public Component m_7626_(ItemStack itemStack) {
        String dimensionTag;
        CompoundTag tag = itemStack.m_41784_();
        String string = tag.m_128441_(POTENTIAL_DIM_TAG) ? POTENTIAL_DIM_TAG : (dimensionTag = tag.m_128441_(SAVED_DIM_TAG) ? SAVED_DIM_TAG : null);
        if (dimensionTag != null) {
            String dimension = MiscHelper.getCleanDimensionName((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(dimensionTag))));
            return Component.m_237113_((String)(dimension + " Sample"));
        }
        return super.m_7626_(itemStack);
    }

    private void savePotentialDim(CompoundTag tag, ResourceKey<Level> dimension) {
        tag.m_128359_(POTENTIAL_DIM_TAG, dimension.m_135782_().toString());
        tag.m_128405_(TIMER_TAG, 0);
    }

    private void saveSavedDim(CompoundTag tag, String potentialDim) {
        tag.m_128359_(SAVED_DIM_TAG, potentialDim);
        tag.m_128473_(POTENTIAL_DIM_TAG);
        tag.m_128473_(TIMER_TAG);
    }

    private void updateTimer(CompoundTag tag, int timer) {
        tag.m_128405_(TIMER_TAG, timer);
    }

    private void resetProgress(CompoundTag tag) {
        tag.m_128473_(POTENTIAL_DIM_TAG);
        tag.m_128473_(TIMER_TAG);
    }

    public static ResourceKey<Level> getSavedDim(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag != null && tag.m_128441_(SAVED_DIM_TAG)) {
            String savedDimString = tag.m_128461_(SAVED_DIM_TAG);
            ResourceLocation savedDimLocation = new ResourceLocation(savedDimString);
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)savedDimLocation);
        }
        return null;
    }

    public static ResourceKey<Level> getPotentialDim(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag != null && tag.m_128441_(POTENTIAL_DIM_TAG)) {
            String savedDimString = tag.m_128461_(POTENTIAL_DIM_TAG);
            ResourceLocation savedDimLocation = new ResourceLocation(savedDimString);
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)savedDimLocation);
        }
        return null;
    }
}

