/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.api.event.ShellChangeSources;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;
import whocraft.tardis_refined.registry.TRUpgrades;

public class C2SChangeShell
extends MessageC2S {
    private final ResourceKey<Level> resourceKey;
    private final ResourceLocation shellTheme;
    private final ShellPattern pattern;

    public C2SChangeShell(ResourceKey<Level> tardisLevel, ResourceLocation theme, ShellPattern pattern) {
        this.resourceKey = tardisLevel;
        this.shellTheme = theme;
        this.pattern = pattern;
    }

    public C2SChangeShell(FriendlyByteBuf buffer) {
        this.resourceKey = buffer.m_236801_(Registries.f_256858_);
        this.shellTheme = buffer.m_130281_();
        this.pattern = ShellPatterns.getPatternOrDefault(this.shellTheme, buffer.m_130281_());
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.CHANGE_SHELL;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_236858_(this.resourceKey);
        buf.m_130085_(this.shellTheme);
        buf.m_130085_(this.pattern.id());
    }

    @Override
    public void handle(MessageContext context) {
        Optional<ServerLevel> level = Optional.ofNullable((ServerLevel)Objects.requireNonNull(context.getPlayer().m_20194_()).f_129762_.get(this.resourceKey));
        level.flatMap(TardisLevelOperator::get).ifPresent(y -> {
            if (TRUpgrades.CHAMELEON_CIRCUIT_SYSTEM.get().isUnlocked(y.getUpgradeHandler()) && y.getExteriorManager().hasEnoughFuelForShellChange()) {
                y.setShellTheme(this.shellTheme, this.pattern.id(), ShellChangeSources.GENERIC_UPDATE);
                y.getPilotingManager().removeFuel(y.getExteriorManager().getFuelForShellChange());
                TardisClientData clientData = y.tardisClientData();
                clientData.setShellTheme(this.shellTheme);
                clientData.setShellPattern(this.pattern.id());
                clientData.sync();
            } else {
                PlayerUtil.sendMessage((LivingEntity)context.getPlayer(), ModMessages.HARDWARE_OFFLINE, true);
            }
        });
    }
}

