/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.sync;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;

public class S2CSyncDesktops
extends MessageS2C {
    private static final Codec<Map<ResourceLocation, DesktopTheme>> MAPPER = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, DesktopTheme.getCodec());
    private Map<ResourceLocation, DesktopTheme> desktops = new HashMap<ResourceLocation, DesktopTheme>();

    public S2CSyncDesktops(Map<ResourceLocation, DesktopTheme> desktops) {
        this.desktops = desktops;
    }

    public S2CSyncDesktops(FriendlyByteBuf buf) {
        this.desktops = MAPPER.parse((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_()).result().orElse(TardisDesktops.registerDefaultDesktops());
    }

    @Override
    public MessageType getType() {
        return TardisNetwork.SYNC_DESKTOPS;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(MAPPER.encodeStart((DynamicOps)NbtOps.f_128958_, this.desktops).result().orElse(new CompoundTag()));
    }

    @Override
    public void handle(MessageContext context) {
        TardisDesktops.getRegistry().clear();
        for (Map.Entry<ResourceLocation, DesktopTheme> entry : this.desktops.entrySet()) {
            TardisDesktops.getRegistry().put(entry.getKey(), entry.getValue());
        }
    }
}

