/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.registry;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.common.tardis.control.Control;
import whocraft.tardis_refined.common.tardis.control.ExteriorDisplayControl;
import whocraft.tardis_refined.common.tardis.control.flight.CoordinateButton;
import whocraft.tardis_refined.common.tardis.control.flight.CoordinateControl;
import whocraft.tardis_refined.common.tardis.control.flight.DimensionalControl;
import whocraft.tardis_refined.common.tardis.control.flight.FastReturnControl;
import whocraft.tardis_refined.common.tardis.control.flight.FuelToggleControl;
import whocraft.tardis_refined.common.tardis.control.flight.GenericControl;
import whocraft.tardis_refined.common.tardis.control.flight.HandbrakeControl;
import whocraft.tardis_refined.common.tardis.control.flight.IncrementControl;
import whocraft.tardis_refined.common.tardis.control.flight.RandomControl;
import whocraft.tardis_refined.common.tardis.control.flight.ReadoutControl;
import whocraft.tardis_refined.common.tardis.control.flight.RotationControl;
import whocraft.tardis_refined.common.tardis.control.flight.ThrottleControl;
import whocraft.tardis_refined.common.tardis.control.ship.MonitorControl;
import whocraft.tardis_refined.common.tardis.control.ship.ToggleDoorControl;
import whocraft.tardis_refined.registry.DeferredRegistry;
import whocraft.tardis_refined.registry.RegistrySupplier;

public class TRControlRegistry {
    public static final ResourceKey<Registry<Control>> CONTROL_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("tardis_refined", "control"));
    public static final DeferredRegistry<Control> CONTROL_DEFERRED_REGISTRY = DeferredRegistry.createCustom("tardis_refined", CONTROL_REGISTRY_KEY, true);
    public static final RegistrySupplier<Control> DOOR_TOGGLE = TRControlRegistry.register(new ToggleDoorControl(new ResourceLocation("tardis_refined", "door_toggle")));
    public static final RegistrySupplier<Control> X = TRControlRegistry.register(new CoordinateControl(CoordinateButton.X, "tardis_refined"));
    public static final RegistrySupplier<Control> Y = TRControlRegistry.register(new CoordinateControl(CoordinateButton.Y, "tardis_refined"));
    public static final RegistrySupplier<Control> Z = TRControlRegistry.register(new CoordinateControl(CoordinateButton.Z, "tardis_refined"));
    public static final RegistrySupplier<Control> INCREMENT = TRControlRegistry.register(new IncrementControl(new ResourceLocation("tardis_refined", "increment")));
    public static final RegistrySupplier<Control> ROTATE = TRControlRegistry.register(new RotationControl(new ResourceLocation("tardis_refined", "rotate")));
    public static final RegistrySupplier<Control> RANDOM = TRControlRegistry.register(new RandomControl(new ResourceLocation("tardis_refined", "random")));
    public static final RegistrySupplier<Control> THROTTLE = TRControlRegistry.register(new ThrottleControl(new ResourceLocation("tardis_refined", "throttle")));
    public static final RegistrySupplier<Control> MONITOR = TRControlRegistry.register(new MonitorControl(new ResourceLocation("tardis_refined", "monitor")));
    public static final RegistrySupplier<Control> DIMENSION = TRControlRegistry.register(new DimensionalControl(new ResourceLocation("tardis_refined", "dimension")));
    public static final RegistrySupplier<Control> FAST_RETURN = TRControlRegistry.register(new FastReturnControl(new ResourceLocation("tardis_refined", "fast_return")));
    public static final RegistrySupplier<Control> READOUT = TRControlRegistry.register(new ReadoutControl(new ResourceLocation("tardis_refined", "read_out")));
    public static final RegistrySupplier<Control> GENERIC_NO_SHOW = TRControlRegistry.register(new GenericControl(new ResourceLocation("tardis_refined", "generic_no_show"), "control.tardis_refined.generic_control"));
    public static final RegistrySupplier<Control> HANDBRAKE = TRControlRegistry.register(new HandbrakeControl(new ResourceLocation("tardis_refined", "hand_brake")));
    public static final RegistrySupplier<Control> FUEL = TRControlRegistry.register(new FuelToggleControl(new ResourceLocation("tardis_refined", "fuel")));
    public static final RegistrySupplier<Control> EXTERIOR_DISPLAY = TRControlRegistry.register(new ExteriorDisplayControl(new ResourceLocation("tardis_refined", "exterior_display")));

    public static Control get(ResourceLocation id) {
        Control potentialTheme = CONTROL_DEFERRED_REGISTRY.get(id);
        if (potentialTheme != null) {
            return potentialTheme;
        }
        return THROTTLE.get();
    }

    public static ResourceLocation getKey(Control control) {
        return CONTROL_DEFERRED_REGISTRY.getKey(control);
    }

    private static RegistrySupplier<Control> register(Control control) {
        return TRControlRegistry.register(control, control.getId().m_135815_());
    }

    private static RegistrySupplier<Control> register(Control control, String id) {
        return CONTROL_DEFERRED_REGISTRY.register(id, () -> control);
    }
}

