/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.registry.forge;

import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import whocraft.tardis_refined.registry.DeferredRegistry;
import whocraft.tardis_refined.registry.RegistrySupplier;

public class DeferredRegistryImpl {
    public static <T> DeferredRegistry<T> create(String modid, ResourceKey<? extends Registry<T>> resourceKey) {
        return new Impl(modid, resourceKey);
    }

    public static <T> DeferredRegistry<T> createCustom(String modid, ResourceKey<Registry<T>> resourceKey, boolean syncToClient) {
        DeferredRegister deferredRegister = DeferredRegister.create(resourceKey, (String)modid);
        Supplier supplier = syncToClient ? deferredRegister.makeRegistry(() -> new RegistryBuilder().setMaxID(0x7FFFFFFE)) : deferredRegister.makeRegistry(() -> new RegistryBuilder().setMaxID(0x7FFFFFFE).disableSync());
        return new Impl<T>(resourceKey, deferredRegister, supplier, syncToClient);
    }

    public static class Impl<T>
    extends DeferredRegistry<T> {
        private final DeferredRegister<T> deferredRegister;
        private final ResourceKey<? extends Registry<T>> resourceKey;
        private final boolean isCustom;
        private final boolean syncToClient;
        private Registry<T> registry;
        private IForgeRegistry<T> forgeRegistry;

        public Impl(ResourceKey<? extends Registry<T>> resourceKey, DeferredRegister<T> deferredRegister, Supplier<IForgeRegistry<T>> forgeRegistry, boolean isCustom, boolean syncToClient) {
            this.resourceKey = resourceKey;
            this.deferredRegister = deferredRegister;
            this.forgeRegistry = forgeRegistry.get();
            this.registry = (Registry)BuiltInRegistries.f_257047_.m_7745_(this.resourceKey.m_135782_());
            this.isCustom = isCustom;
            this.syncToClient = syncToClient;
        }

        public Impl(ResourceKey<? extends Registry<T>> resourceKey, DeferredRegister<T> deferredRegister, Supplier<IForgeRegistry<T>> forgeRegistry, boolean syncToClient) {
            this(resourceKey, deferredRegister, forgeRegistry, true, syncToClient);
        }

        public Impl(String modid, ResourceKey<? extends Registry<T>> resourceKey) {
            this(resourceKey, DeferredRegister.create(resourceKey, (String)modid), () -> RegistryManager.ACTIVE.getRegistry(resourceKey), false, false);
        }

        @Override
        public void registerToModBus() {
            this.deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
        }

        @Override
        public <R extends T> RegistrySupplier<R> register(String id, Supplier<R> supplier) {
            RegistryObject orig = this.deferredRegister.register(id, supplier);
            RegistrySupplier<RegistryObject> registrySupplier = new RegistrySupplier<RegistryObject>(orig.getId(), orig);
            return registrySupplier;
        }

        public IForgeRegistry<T> getForgeRegistry() {
            if (this.forgeRegistry == null) {
                this.forgeRegistry = RegistryManager.ACTIVE.getRegistry(this.resourceKey);
            }
            return this.forgeRegistry;
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return this.resourceKey;
        }

        @Override
        public T get(ResourceLocation key) {
            return (T)this.getForgeRegistry().getValue(key);
        }

        @Override
        public ResourceLocation getKey(T object) {
            return this.getForgeRegistry().getKey(object);
        }

        @Override
        public boolean containsKey(ResourceLocation key) {
            return this.getForgeRegistry().containsKey(key);
        }

        @Override
        public Set<ResourceLocation> keySet() {
            return this.getForgeRegistry().getKeys();
        }

        @Override
        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return this.getForgeRegistry().getEntries();
        }

        @Override
        public Supplier<Codec<T>> getCodec() {
            return () -> this.getForgeRegistry().getCodec();
        }
    }
}

