/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JarBlock
extends Block {
    public static final int MAX_JARS = 4;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty JARS = IntegerProperty.m_61631_((String)"jars", (int)1, (int)4);
    protected static final VoxelShape ONE_NORTH = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)7.0, (double)8.0, (double)7.0);
    protected static final VoxelShape ONE_EAST = Block.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)7.0);
    protected static final VoxelShape ONE_SOUTH = Block.m_49796_((double)9.0, (double)0.0, (double)9.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape ONE_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)7.0, (double)8.0, (double)15.0);
    protected static final VoxelShape TWO_NORTH = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)7.0);
    protected static final VoxelShape TWO_EAST = Block.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape TWO_SOUTH = Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape TWO_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)7.0, (double)8.0, (double)15.0);
    protected static final VoxelShape THREE_NORTH;
    protected static final VoxelShape THREE_EAST;
    protected static final VoxelShape THREE_SOUTH;
    protected static final VoxelShape THREE_WEST;
    protected static final VoxelShape FOUR_NORTH;
    protected static final VoxelShape FOUR_EAST;
    protected static final VoxelShape FOUR_SOUTH;
    protected static final VoxelShape FOUR_WEST;

    public JarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)JARS, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos;
        Level world = ctx.m_43725_();
        BlockState here = world.m_8055_(pos = ctx.m_8083_());
        if (here.m_60713_((Block)this)) {
            int c = (Integer)here.m_61143_((Property)JARS);
            return (BlockState)here.m_61124_((Property)JARS, (Comparable)Integer.valueOf(Math.min(4, c + 1)));
        }
        for (Direction d : ctx.m_6232_()) {
            if (!d.m_122434_().m_122479_()) continue;
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)d)).m_61124_((Property)JARS, (Comparable)Integer.valueOf(1));
        }
        return this.m_49966_();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext ctx) {
        return !ctx.m_7078_() && ctx.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)JARS) < 4 || super.m_6864_(state, ctx);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        int jars = (Integer)state.m_61143_((Property)JARS);
        Direction face = (Direction)state.m_61143_((Property)FACING);
        switch (jars) {
            case 2: {
                switch (face) {
                    case EAST: {
                        return TWO_EAST;
                    }
                    case SOUTH: {
                        return TWO_SOUTH;
                    }
                    case WEST: {
                        return TWO_WEST;
                    }
                }
                return TWO_NORTH;
            }
            case 3: {
                switch (face) {
                    case EAST: {
                        return THREE_EAST;
                    }
                    case SOUTH: {
                        return THREE_SOUTH;
                    }
                    case WEST: {
                        return THREE_WEST;
                    }
                }
                return THREE_NORTH;
            }
            case 4: {
                switch (face) {
                    case EAST: {
                        return FOUR_EAST;
                    }
                    case SOUTH: {
                        return FOUR_SOUTH;
                    }
                    case WEST: {
                        return FOUR_WEST;
                    }
                }
                return FOUR_NORTH;
            }
        }
        switch (face) {
            case EAST: {
                return ONE_EAST;
            }
            case SOUTH: {
                return ONE_SOUTH;
            }
            case WEST: {
                return ONE_WEST;
            }
        }
        return ONE_NORTH;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.m_5940_(state, world, pos, ctx);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{JARS, FACING});
    }

    static {
        THREE_EAST = THREE_NORTH = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
        THREE_SOUTH = THREE_NORTH;
        THREE_WEST = THREE_NORTH;
        FOUR_EAST = FOUR_NORTH = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
        FOUR_SOUTH = FOUR_NORTH;
        FOUR_WEST = FOUR_NORTH;
    }
}

