/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.network.c2s;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_machinery.Common;
import immersive_machinery.entity.BambooBee;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class BambooBeeConfigurationUpdate
extends Message {
    private final int id;
    private final BambooBee.Configuration configuration;

    public BambooBeeConfigurationUpdate(BambooBee bee) {
        this.id = bee.m_19879_();
        this.configuration = bee.getConfiguration();
    }

    public BambooBeeConfigurationUpdate(FriendlyByteBuf b) {
        this.id = b.readInt();
        this.configuration = new BambooBee.Configuration();
        this.configuration.decode(b);
    }

    public void encode(FriendlyByteBuf b) {
        b.writeInt(this.id);
        this.configuration.encode(b);
    }

    public void receive(Player e) {
        if (e == null || e.m_9236_().f_46443_) {
            Common.networkManager.handleBambooBeeConfiguration(this);
        } else {
            this.read(e.m_9236_().m_6815_(this.id));
            for (Player player : e.m_9236_().m_6907_()) {
                if (player == e || !(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!(player.m_20280_((Entity)e) < 256.0)) continue;
                NetworkHandler.sendToPlayer((Message)this, (ServerPlayer)serverPlayer);
            }
        }
    }

    public void read(Entity entity) {
        if (entity instanceof BambooBee) {
            BambooBee bee = (BambooBee)entity;
            bee.setConfiguration(this.configuration);
        }
    }

    public int getId() {
        return this.id;
    }
}

