/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
    }

    public static class ClientConfig {
        static final ClientConfig CONFIG;
        static final ForgeConfigSpec SPEC;
        final ForgeConfigSpec.ConfigValue<Boolean> sortingModule;
        final ForgeConfigSpec.ConfigValue<Boolean> wheelmoveModule;

        private ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Inventory sorter modules");
            builder.push("modules");
            this.sortingModule = builder.comment("Sorting module").translation("inventorysorter.config.sortingmodule").define("sortingmodule", true);
            this.wheelmoveModule = builder.comment("Wheel move module").translation("inventorysorter.config.wheelmovemodule").define("wheelmovemodule", true);
            builder.pop();
        }

        static {
            Pair conf = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
            CONFIG = (ClientConfig)conf.getLeft();
            SPEC = (ForgeConfigSpec)conf.getRight();
        }
    }

    public static class ServerConfig {
        static final ServerConfig CONFIG;
        static final ForgeConfigSpec SPEC;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> containerBlacklist;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> slotBlacklist;

        private ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Inventory sorter blacklists");
            builder.push("blacklists");
            this.containerBlacklist = builder.comment("Container blacklist").translation("inventorysorter.config.containerblacklist").defineList("containerBlacklist", ArrayList::new, t -> true);
            this.slotBlacklist = builder.comment("Slot type blacklist").translation("inventorysorter.config.slotblacklist").defineList("slotBlacklist", new ArrayList(), t -> true);
            builder.pop();
        }

        static {
            Pair conf = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
            CONFIG = (ServerConfig)conf.getLeft();
            SPEC = (ForgeConfigSpec)conf.getRight();
        }
    }
}

