/*
 * Decompiled with CFR 0.152.
 */
package com.mcwstairs.kikoz.objects;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BalconyRailing
extends Block {
    public static final EnumProperty<RailingStyle> STYLE = EnumProperty.m_61587_((String)"style", RailingStyle.class);
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    private static final VoxelShape VEAST = Block.m_49796_((double)16.0, (double)0.0, (double)0.0, (double)18.0, (double)15.0, (double)16.0);
    private static final VoxelShape VSOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0, (double)18.0);
    private static final VoxelShape VWEST = Block.m_49796_((double)-2.0, (double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0);
    private static final VoxelShape VNORTH = Block.m_49796_((double)0.0, (double)0.0, (double)-2.0, (double)16.0, (double)15.0, (double)0.0);
    public static final VoxelShape E_COLLISION = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)26.0, (double)16.0);
    public static final VoxelShape S_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)26.0, (double)16.0);
    public static final VoxelShape W_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)26.0, (double)16.0);
    public static final VoxelShape N_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)26.0, (double)1.0);
    private static final VoxelShape VBASE_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0);
    private static final VoxelShape VBASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.01, (double)16.0);

    public BalconyRailing(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_(STYLE, (Comparable)((Object)RailingStyle.CLASSIC)));
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter blockReader, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_().m_7495_();
        Level world = context.m_43725_();
        BlockState stateBelow = world.m_8055_(pos);
        if (stateBelow.m_60734_() instanceof BalconyRailing) {
            return null;
        }
        Direction direction = context.m_8125_();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)EAST, (Comparable)Boolean.valueOf(direction == Direction.EAST))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(direction == Direction.WEST))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(direction == Direction.NORTH))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(direction == Direction.SOUTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        VoxelShape shape = VBASE;
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VEAST);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VWEST);
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VNORTH);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VSOUTH);
        }
        return shape;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        VoxelShape shape = VBASE_COLLISION;
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)E_COLLISION);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)W_COLLISION);
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)N_COLLISION);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)S_COLLISION);
        }
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EAST, WEST, NORTH, SOUTH, STYLE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        Item item = heldItem.m_41720_();
        if (heldItem.m_41720_() instanceof BlockItem && ((BlockItem)heldItem.m_41720_()).m_40614_() instanceof BalconyRailing) {
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            Direction direction = player.m_6350_();
            BooleanProperty directionProperty = this.getDirectionProperty(direction);
            boolean currentDirectionValue = (Boolean)state.m_61143_((Property)directionProperty);
            if (!currentDirectionValue) {
                BlockState newState = (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Boolean.valueOf(true));
                level.m_7731_(pos, newState, 3);
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (item == Items.f_42574_) {
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            RailingStyle currentStyle = (RailingStyle)((Object)state.m_61143_(STYLE));
            RailingStyle[] styles = RailingStyle.values();
            int newIndex = (currentStyle.ordinal() + 1) % styles.length;
            RailingStyle newStyle = styles[newIndex];
            BlockState newState = (BlockState)state.m_61124_(STYLE, (Comparable)((Object)newStyle));
            level.m_7731_(pos, newState, 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private BooleanProperty getDirectionProperty(Direction direction) {
        switch (direction) {
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + String.valueOf(direction));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && !player.m_7500_()) {
            int dropCount = 0;
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                ++dropCount;
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                ++dropCount;
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                ++dropCount;
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                ++dropCount;
            }
            ItemStack stack = new ItemStack((ItemLike)this);
            for (int i = 0; i < dropCount; ++i) {
                BalconyRailing.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack.m_41777_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static enum RailingStyle implements StringRepresentable
    {
        CLASSIC("classic"),
        HARP("harp"),
        SMOOTH("smooth");

        private final String name;

        private RailingStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

