/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.dragonegg.moreburners.compat.pneumaticcraft.PneumaticCraftCompat;
import net.dragonegg.moreburners.content.block.BaseBurnerBlock;
import net.dragonegg.moreburners.content.block.entity.HeatConverterBlockEntity;
import net.dragonegg.moreburners.util.BurnerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class HeatConverterBlock
extends BaseBurnerBlock
implements IBlockComparatorSupport,
IPneumaticWrenchable {
    public HeatConverterBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new HeatConverterBlockEntity(pPos, pState);
    }

    public int getTintColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        if (world != null && pos != null) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof HeatConverterBlockEntity) {
                HeatConverterBlockEntity heatConverter = (HeatConverterBlockEntity)blockEntity;
                if (tintIndex == 0) {
                    return heatConverter.getColorForTintIndex(tintIndex).getRGB();
                }
                return BurnerUtil.getColor((BlazeBurnerBlock.HeatLevel)state.m_61143_((Property)HEAT_LEVEL));
            }
            return 0xFFFFFF;
        }
        return -1;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof HeatConverterBlockEntity) {
            HeatConverterBlockEntity he = (HeatConverterBlockEntity)te;
            he.initHeatExchangersOnPlacement(world, pos);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.m_5776_()) {
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, (BlockPos)pos, HeatConverterBlockEntity.class).ifPresent(pncBE -> pncBE.onNeighborBlockUpdate(fromPos));
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return HeatConverterBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)PneumaticCraftCompat.HEAT_CONVERTER_ENTITY.get()), (level1, pos, state1, entity) -> entity.tick(level1, pos, state1));
    }

    public boolean onWrenched(Level level, Player player, BlockPos pos, Direction direction, InteractionHand interactionHand) {
        if (player != null && player.m_6144_()) {
            BlockEntity te = level.m_7702_(pos);
            if (!player.m_7500_()) {
                Block.m_49892_((BlockState)level.m_8055_(pos), (LevelAccessor)level, (BlockPos)pos, (BlockEntity)te);
            }
            HeatConverterBlock.removeBlockSneakWrenched(level, pos);
            return true;
        }
        return false;
    }

    static void removeBlockSneakWrenched(Level world, BlockPos pos) {
        if (!world.m_5776_()) {
            world.m_7471_(pos, false);
            PneumaticRegistry.getInstance().getMiscHelpers().forceClientShapeRecalculation(world, pos);
        }
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity te, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            AbstractPneumaticCraftBlockEntity base;
            ServerPlayer sp = (ServerPlayer)player;
            if (!(player instanceof FakePlayer) && te instanceof AbstractPneumaticCraftBlockEntity && !(base = (AbstractPneumaticCraftBlockEntity)te).shouldPreserveStateOnBreak()) {
                AdvancementTriggers.MACHINE_VANDAL.trigger(sp);
            }
        }
        super.m_6240_(worldIn, player, pos, state, te, stack);
    }
}

