/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.util;

import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import net.dragonegg.moreburners.MoreBurners;
import net.dragonegg.moreburners.compat.pneumaticcraft.PneumaticCraftCompat;
import net.dragonegg.moreburners.content.block.BaseBurnerBlock;
import net.dragonegg.moreburners.content.block.entity.HeatConverterBlockEntity;
import net.dragonegg.moreburners.util.BurnerUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class BoilerHeaterRegistry {
    public static void registerBoilerHeaters() {
        for (Block block : BurnerUtil.getBurners()) {
            BoilerHeaterRegistry.register(block);
        }
        if (MoreBurners.loadedPNE()) {
            BoilerHeaterRegistry.registerPNEBlocks();
        }
    }

    public static float fromHeatLevel(BlazeBurnerBlock.HeatLevel value) {
        return switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case BlazeBurnerBlock.HeatLevel.NONE -> -1.0f;
            case BlazeBurnerBlock.HeatLevel.SMOULDERING -> 0.0f;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> 1.0f;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> 2.0f;
        };
    }

    public static void register(Block block) {
        if (!(block instanceof BaseBurnerBlock)) {
            return;
        }
        BoilerHeater.REGISTRY.register((Object)block, (level, pos, state) -> BoilerHeaterRegistry.fromHeatLevel((BlazeBurnerBlock.HeatLevel)state.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL)));
    }

    public static void registerPNEBlocks() {
        PneumaticCraftCompat.streamBlockEntities().forEach(be -> {
            if (be instanceof IHeatExchangingTE) {
                BoilerHeater.REGISTRY.register((Object)be.m_58900_().m_60734_(), (level, pos, state) -> {
                    IHeatExchangingTE heatTE;
                    IHeatExchangerLogic logic;
                    BlockEntity patt1862$temp = level.m_7702_(pos);
                    if (patt1862$temp instanceof IHeatExchangingTE && (logic = (heatTE = (IHeatExchangingTE)patt1862$temp).getHeatExchanger(Direction.UP)) != null) {
                        return BoilerHeaterRegistry.fromHeatLevel(HeatConverterBlockEntity.getHeatLevel(logic.getTemperature()));
                    }
                    return -1.0f;
                });
            }
        });
    }
}

