/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.util;

import com.rekindled.embers.RegistryManager;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.dragonegg.moreburners.MoreBurners;
import net.dragonegg.moreburners.compat.embers.EmbersCompat;
import net.dragonegg.moreburners.compat.pneumaticcraft.PneumaticCraftCompat;
import net.dragonegg.moreburners.content.block.BaseBurnerBlock;
import net.dragonegg.moreburners.registry.BlockRegistry;
import net.dragonegg.moreburners.registry.ItemRegistry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class BurnerUtil {
    public static HashMap<Block, Item> CATALYST = new HashMap();

    public static void initCatalyst() {
        if (MoreBurners.loadedEmber()) {
            CATALYST.put((Block)EmbersCompat.EMBER_BURNER.get(), (Item)RegistryManager.ATMOSPHERIC_BELLOWS_ITEM.get());
        }
        if (MoreBurners.loadedPNE()) {
            CATALYST.put((Block)PneumaticCraftCompat.HEAT_CONVERTER.get(), Items.f_41852_);
        }
        CATALYST.put((Block)BlockRegistry.ELECTRIC_BURNER.get(), (Item)ItemRegistry.HEAT_UPGRADE.get());
    }

    public static List<Block> getBurners() {
        ArrayList<Block> burners = new ArrayList<Block>();
        for (RegistryObject blockRegistryObject : BlockRegistry.BLOCKS.getEntries()) {
            burners.add((Block)blockRegistryObject.get());
        }
        return burners;
    }

    public static List<ItemStack> getBurnerStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Block burner : BurnerUtil.getBurners()) {
            stacks.add(burner.m_5456_().m_7968_());
        }
        return stacks;
    }

    public static BlockState getBurnerState(Block block, BlazeBurnerBlock.HeatLevel level) {
        if (block instanceof BaseBurnerBlock) {
            BaseBurnerBlock burner = (BaseBurnerBlock)block;
            return burner.getState(level);
        }
        return null;
    }

    public static int getColor(BlazeBurnerBlock.HeatLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case BlazeBurnerBlock.HeatLevel.NONE, BlazeBurnerBlock.HeatLevel.SMOULDERING -> 0xFFFFFF;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> 13319431;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> 3840759;
        };
    }
}

