/*
 * Decompiled with CFR 0.152.
 */
package novamachina.novacore.data.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import novamachina.novacore.data.tags.IntrinsicTagBuilder;
import novamachina.novacore.data.tags.TagBuilder;
import novamachina.novacore.world.level.block.BlockDefinition;
import novamachina.novacore.world.level.material.FluidDefinition;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TagProvider
implements DataProvider {
    private final PackOutput output;
    private final String modId;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final ExistingFileHelper existingFileHelper;
    private final Map<ResourceKey<? extends Registry<?>>, Map<TagKey<?>, net.minecraft.tags.TagBuilder>> supportedTagTypes = new HashMap();
    private Set<Block> knownHarvestRequirements = new HashSet<Block>();

    protected TagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this.output = output;
        this.modId = modId;
        this.lookupProvider = lookupProvider;
        this.existingFileHelper = existingFileHelper;
    }

    public @NonNull CompletableFuture<?> m_213708_(@NonNull CachedOutput cache) {
        return ((CompletableFuture)this.lookupProvider.thenApply(registries -> {
            this.supportedTagTypes.values().forEach(Map::clear);
            this.registerTags();
            return registries;
        })).thenCompose(registries -> {
            for (BlockDefinition<?> blockDefinition : this.getAllBlocks()) {
                Object block = blockDefinition.block();
                if (!block.m_49966_().m_60834_() || this.knownHarvestRequirements.contains(block)) continue;
                throw new IllegalStateException(String.format("Missing harvest tool type for block %s that requires the correct tool for drops.", blockDefinition.getId()));
            }
            ArrayList futures = new ArrayList();
            this.supportedTagTypes.forEach((registry, tagTypeMap) -> {
                if (!tagTypeMap.isEmpty()) {
                    futures.add(new TagsProvider(this.output, (ResourceKey)registry, this.lookupProvider, this.modId, this.existingFileHelper, (Map)tagTypeMap){
                        final /* synthetic */ Map val$tagTypeMap;
                        {
                            this.val$tagTypeMap = map;
                            super(pOutput, pRegistryKey, pLookupProvider, modId, existingFileHelper);
                        }

                        protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
                         @NonNull HolderLookup.Provider lookupProvider) {
                            this.val$tagTypeMap.forEach((tag, tagBuilder) -> this.f_126543_.put(tag.f_203868_(), tagBuilder));
                        }
                    }.m_213708_(cache));
                }
            });
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    private List<BlockDefinition<?>> getAllBlocks() {
        return Collections.emptyList();
    }

    protected abstract void registerTags();

    public @NonNull String m_6055_() {
        return String.format("Tags: %s", this.modId);
    }

    private <TYPE> Map<TagKey<?>, net.minecraft.tags.TagBuilder> getTagTypeMap(ResourceKey<? extends Registry<TYPE>> registry) {
        return this.supportedTagTypes.computeIfAbsent(registry, type -> new HashMap());
    }

    private <TYPE> net.minecraft.tags.TagBuilder getTagBuilder(ResourceKey<? extends Registry<TYPE>> registry, TagKey<TYPE> tag) {
        return this.getTagTypeMap(registry).computeIfAbsent(tag, ignored -> net.minecraft.tags.TagBuilder.m_215899_());
    }

    protected <TYPE> TagBuilder<TYPE, ?> getBuilder(ResourceKey<? extends Registry<TYPE>> registry, TagKey<TYPE> tag) {
        return new TagBuilder(this.getTagBuilder(registry, tag), this.modId);
    }

    protected <TYPE> IntrinsicTagBuilder<TYPE> getBuilder(IForgeRegistry<TYPE> registry, TagKey<TYPE> tag) {
        return new IntrinsicTagBuilder<Object>(element -> (ResourceKey)registry.getResourceKey(element).orElseThrow(), this.getTagBuilder(registry.getRegistryKey(), tag), this.modId);
    }

    protected IntrinsicTagBuilder<Block> getBlockBuilder(TagKey<Block> tag) {
        return this.getBuilder(ForgeRegistries.BLOCKS, tag);
    }

    protected IntrinsicTagBuilder<Item> getItemBuilder(TagKey<Item> tag) {
        return this.getBuilder(ForgeRegistries.ITEMS, tag);
    }

    protected IntrinsicTagBuilder<Fluid> getFluidBuilder(TagKey<Fluid> tag) {
        return this.getBuilder(ForgeRegistries.FLUIDS, tag);
    }

    protected void addToTag(TagKey<Block> tag, Block ... blocks) {
        this.getBlockBuilder(tag).add((Block[])blocks);
    }

    protected void addToTag(TagKey<Item> tag, ItemLike ... items) {
        this.getItemBuilder(tag).addTyped(ItemLike::m_5456_, items);
    }

    protected void addToTag(TagKey<Fluid> tag, FluidDefinition<?, ?, ?> ... fluids) {
        IntrinsicTagBuilder<Fluid> tagBuilder = this.getFluidBuilder(tag);
        for (FluidDefinition<?, ?, ?> fluid : fluids) {
            tagBuilder.add((Fluid[])new Fluid[]{fluid.getStillFluid(), fluid.getFlowingFluid()});
        }
    }
}

