/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.config;

import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.data.json.EquipmentAttachment;
import com.nukateam.chassis_core.modules.config.annotation.Ignored;
import com.nukateam.chassis_core.modules.config.annotation.Optional;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class EquipmentConfig
implements INBTSerializable<CompoundTag> {
    @Ignored
    private ChassisPart part;
    @Optional
    LinkedHashSet<ResourceLocation> chassis;
    @Optional
    public ResourceLocation parent;
    @Ignored
    public ResourceLocation model;
    @Ignored
    public HashMap<String, ResourceLocation> texture;
    @Ignored
    public ArrayList<EquipmentAttachment> attachments = new ArrayList();
    @Optional
    public ArrayList<String> hide = new ArrayList();
    @Optional
    public ArrayList<String> mods = new ArrayList();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("part", this.part.toString());
        tag.m_128365_("chassis", (Tag)NbtUtils.serializeSet(this.chassis));
        tag.m_128359_("model", this.model.toString());
        tag.m_128365_("texture", (Tag)NbtUtils.serializeStringMap(this.texture));
        tag.m_128365_("attachments", (Tag)NbtUtils.serializeArray(this.attachments));
        tag.m_128365_("hide", (Tag)NbtUtils.serializeStringArray(this.hide));
        tag.m_128365_("mods", (Tag)NbtUtils.serializeStringArray(this.mods));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("part", 8)) {
            this.part = ChassisPart.getType(tag.m_128461_("part"));
        }
        if (tag.m_128425_("chassis", 10)) {
            this.chassis = NbtUtils.deserializeResourceLocationSet(tag.m_128469_("chassis"));
        }
        if (tag.m_128425_("model", 8)) {
            this.model = ResourceLocation.m_135820_((String)tag.m_128461_("model"));
        }
        if (tag.m_128425_("texture", 10)) {
            this.texture = NbtUtils.deserializeRLMap(tag.m_128469_("texture"));
        }
        if (tag.m_128425_("attachments", 10)) {
            this.attachments = NbtUtils.deserializeArray(tag.m_128469_("attachments"), EquipmentAttachment::create);
        }
        if (tag.m_128425_("hide", 10)) {
            this.hide = NbtUtils.deserializeStringArray(tag.m_128469_("hide"));
        }
        if (tag.m_128425_("mods", 10)) {
            this.mods = NbtUtils.deserializeStringArray(tag.m_128469_("mods"));
        }
    }

    public EquipmentConfig copy() {
        EquipmentConfig config = new EquipmentConfig();
        config.part = this.part;
        config.chassis = this.chassis;
        config.model = this.model;
        return config;
    }

    public static EquipmentConfig create(CompoundTag tag) {
        EquipmentConfig config = new EquipmentConfig();
        config.deserializeNBT(tag);
        return config;
    }

    public ChassisPart getPart() {
        return this.part;
    }

    public Set<ResourceLocation> getChassis() {
        return this.chassis;
    }

    public Collection<String> getAllVariants() {
        return this.texture.keySet();
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public ResourceLocation getTexture(String tag) {
        return this.texture.get(tag);
    }

    public ResourceLocation getParent() {
        return this.parent;
    }

    public HashMap<String, ResourceLocation> getTextures() {
        return this.texture;
    }

    public ArrayList<EquipmentAttachment> getAttachments() {
        return this.attachments;
    }

    public ArrayList<String> getHide() {
        return this.hide;
    }

    public ArrayList<String> getMods() {
        return this.mods;
    }

    @Nullable
    public Collection<String> getArmorBone(String chassisBone) {
        ArrayList<String> result = new ArrayList<String>();
        for (EquipmentAttachment attachment : this.attachments) {
            if (!Objects.equals(attachment.frame, chassisBone)) continue;
            result.add(attachment.armor);
        }
        return result;
    }

    public static class Builder {
        private final EquipmentConfig config;

        private Builder() {
            this.config = new EquipmentConfig();
        }

        private Builder(EquipmentConfig projectile) {
            this.config = projectile.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EquipmentConfig projectile) {
            return new Builder(projectile);
        }

        public EquipmentConfig build() {
            return this.config.copy();
        }

        public Builder setPart(ChassisPart part) {
            this.config.part = part;
            return this;
        }
    }
}

