/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.foundation.entity;

import com.google.common.collect.ImmutableMap;
import com.nukateam.chassis_core.Global;
import com.nukateam.chassis_core.client.animators.HandAnimator;
import com.nukateam.chassis_core.client.render.renderers.CustomHandRenderer;
import com.nukateam.chassis_core.common.data.constants.Resources;
import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.foundation.entity.Chassis;
import com.nukateam.chassis_core.common.foundation.item.ChassisEquipment;
import com.nukateam.chassis_core.common.util.helpers.Speedometer;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class WearableChassis
extends Chassis
implements GeoEntity {
    public static final float ROTATION = (float)Math.PI / 180;
    public static final int EFFECT_DURATION = 9;
    public static final HandAnimator HAND_ENTITY = new HandAnimator();
    private static final Lazy<CustomHandRenderer> HAND_RENDERER = Lazy.of(() -> new CustomHandRenderer());
    public static final ResourceLocation DEFAULT_ICON = Resources.resourceLocation("textures/item/chassis.png");
    public static final float STEP_HEIGHT = 0.5f;
    public final Speedometer speedometer = new Speedometer((Entity)this);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected boolean isJumping;
    protected float jumpScale;
    public float bob;
    public float oBob;
    public static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.m_20395_((float)1.0f, (float)2.3f);
    public static final EntityDimensions CROUCHING_DIMENSIONS = EntityDimensions.m_20395_((float)1.0f, (float)2.0f);
    protected final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)this.getStandingDimensions()).put((Object)Pose.CROUCHING, (Object)this.getCrouchingDimensions()).build();

    public WearableChassis(EntityType<? extends Chassis> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Chassis.m_21183_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22288_, 0.5).m_22268_(Attributes.f_22278_, 0.8);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return this.POSES.getOrDefault(pPose, STANDING_DIMENSIONS);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.speedometer.tick();
        this.timer.tick();
        this.updatePose();
    }

    public boolean m_264410_() {
        return true;
    }

    public float getStepHeight() {
        if (this.hasPlayerPassenger()) {
            return 0.5f;
        }
        return super.getStepHeight();
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        LivingEntity passenger = this.m_6688_();
        if (passenger != null) {
            passenger.m_6469_(damageSource, damage);
        }
        return false;
    }

    public float getDamageAfterAbsorb(DamageSource damageSource, float damage) {
        float finalDamage = this.getDamageAfterAbsorb(damage);
        this.damageArmor(damageSource, damage);
        LivingEntity passenger = this.m_6688_();
        if (this.hasPassenger() && damageSource.m_7639_() == passenger) {
            return 0.0f;
        }
        return finalDamage;
    }

    public void m_8107_() {
        this.updateBobing();
        super.m_8107_();
        if (this.hasPassenger()) {
            this.f_20885_ = this.m_146908_();
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (super.m_6673_(damageSource)) {
            return true;
        }
        return damageSource.m_7639_() == this.m_6688_();
    }

    public InteractionResult m_7111_(Player player, Vec3 vector, InteractionHand hand) {
        if (this.isServerSide && !player.m_20159_()) {
            if (player.m_6144_()) {
                this.openGUI(player);
                return InteractionResult.SUCCESS;
            }
            if (!this.m_20160_()) {
                this.ride((LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Object e;
        if (!this.m_20197_().isEmpty() && (e = this.m_20197_().get(0)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)e;
            return livingEntity;
        }
        return null;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction pCallback) {
        super.m_19956_(entity, pCallback);
        LivingEntity passenger = this.m_6688_();
        if (passenger == null) {
            return;
        }
        float yOffset = 1.0f;
        double posY = this.m_20186_() + this.m_6048_() + entity.m_6049_() - (double)yOffset;
        entity.m_6034_(this.m_20185_(), posY, this.m_20189_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_20883_ = this.f_20883_;
        }
    }

    public float m_274460_() {
        if (this.hasPlayerPassenger() && this.isPlayerFlying() && !this.m_20159_()) {
            float speed = this.getPlayerPassenger().m_150110_().m_35942_();
            return this.m_20142_() ? speed * 2.0f : speed;
        }
        return this.m_20142_() ? 0.025999999f : 0.02f;
    }

    public boolean m_6129_() {
        return this.isPlayerFlying();
    }

    public boolean m_6047_() {
        if (this.hasPlayerPassenger()) {
            return this.getPlayerPassenger().m_6144_();
        }
        return super.m_6047_();
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.m_6084_()) {
            return;
        }
        if (this.isPlayerFlying()) {
            this.creativeFlyTravel();
            return;
        }
        this.m_20242_(false);
        if (this.m_20160_() && this.hasPassenger()) {
            this.travelWithPassenger(travelVector);
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6144_() {
        boolean bl;
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            bl = player.m_6144_();
        } else {
            bl = super.m_6144_();
        }
        return bl;
    }

    protected Vec3 m_5763_(Vec3 pVec, MoverType pMover) {
        if (!this.isPlayerFlying() && pVec.f_82480_ <= 0.0 && (pMover == MoverType.SELF || pMover == MoverType.PLAYER) && this.m_6144_() && this.isAboveGround()) {
            double x = pVec.f_82479_;
            double z = pVec.f_82481_;
            double edge = 0.05;
            while (x != 0.0 && this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(x, (double)(-this.m_274421_()), 0.0))) {
                if (x < edge && x >= -edge) {
                    x = 0.0;
                    continue;
                }
                if (x > 0.0) {
                    x -= edge;
                    continue;
                }
                x += edge;
            }
            while (z != 0.0 && this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(0.0, (double)(-this.m_274421_()), z))) {
                if (z < edge && z >= -edge) {
                    z = 0.0;
                    continue;
                }
                if (z > 0.0) {
                    z -= edge;
                    continue;
                }
                z += edge;
            }
            while (x != 0.0 && z != 0.0 && this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(x, (double)(-this.m_274421_()), z))) {
                x = x < edge && x >= -edge ? 0.0 : (x > 0.0 ? (x -= edge) : (x += edge));
                if (z < edge && z >= -edge) {
                    z = 0.0;
                    continue;
                }
                if (z > 0.0) {
                    z -= edge;
                    continue;
                }
                z += edge;
            }
            pVec = new Vec3(x, pVec.f_82480_, z);
        }
        return pVec;
    }

    public boolean m_20068_() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player.m_150110_().f_35935_;
        }
        return super.m_20068_();
    }

    private Vec3 calculateDesiredMotion(Vec3 look, float forward, float strafe, float vertical) {
        Vec3 horizontal = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_().m_82490_((double)forward).m_82549_(new Vec3(look.f_82481_, 0.0, -look.f_82479_).m_82541_().m_82490_((double)strafe));
        Vec3 verticalVec = new Vec3(0.0, (double)vertical, 0.0);
        return horizontal.m_82549_(verticalVec).m_82541_();
    }

    private Vec3 applyAcceleration(Vec3 current, Vec3 desired, float acceleration) {
        return new Vec3(this.lerp(current.f_82479_, desired.f_82479_, acceleration), this.lerp(current.f_82480_, desired.f_82480_, acceleration), this.lerp(current.f_82481_, desired.f_82481_, acceleration));
    }

    private double lerp(double a, double b, float t) {
        return a + (b - a) * (double)t;
    }

    public Vec3 m_7688_(LivingEntity p_20123_) {
        return super.m_7688_(p_20123_);
    }

    public void m_6043_() {
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_275843_() {
        return false;
    }

    protected float m_5632_(float pYRot, float pAnimStep) {
        if (this.hasPassenger()) {
            return super.m_5632_(pYRot, pAnimStep);
        }
        return pAnimStep;
    }

    public float m_274421_() {
        float f = super.m_274421_();
        return !this.hasPlayerPassenger() ? Math.max(f, 1.0f) : f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public ChassisEquipment getEquipmentItem(ChassisPart part) {
        ItemStack stack = this.getEquipment(part);
        if (!stack.m_41619_()) {
            return (ChassisEquipment)stack.m_41720_();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HandAnimator getHandEntity() {
        return HAND_ENTITY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public CustomHandRenderer getHandRenderer() {
        return (CustomHandRenderer)((Object)HAND_RENDERER.get());
    }

    public ResourceLocation getIcon() {
        return DEFAULT_ICON;
    }

    public boolean renderHand() {
        return true;
    }

    public void openGUI(Player player) {
        Global.referenceMob = this;
        MenuProvider provider = this.getMenuProvider();
        if (provider != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)provider, buf -> buf.writeInt(this.m_19879_()));
        }
    }

    public void openStationGUI(Player player) {
        Global.referenceMob = this;
        MenuProvider provider = this.getStantionMenuProvider();
        if (this.isServerSide && provider != null) {
            player.m_5893_(provider);
        }
    }

    public EntityDimensions getStandingDimensions() {
        return STANDING_DIMENSIONS;
    }

    public EntityDimensions getCrouchingDimensions() {
        return CROUCHING_DIMENSIONS;
    }

    @Nullable
    protected abstract MenuProvider getStantionMenuProvider();

    protected float getCrouchingSpeed() {
        return this.getSpeedAttribute() / 2.0f;
    }

    protected float getSprintingSpeed() {
        return this.getSpeedAttribute() * 1.5f;
    }

    protected void updatePose() {
        Pose pose;
        if (this.hasPlayerPassenger() && this.getPlayerPassenger().m_6144_()) {
            pose = Pose.CROUCHING;
            this.m_7910_(this.getCrouchingSpeed());
        } else {
            pose = Pose.STANDING;
            if (this.hasPlayerPassenger() && this.getPlayerPassenger().m_20142_()) {
                this.m_7910_(this.getSprintingSpeed());
            } else {
                this.m_7910_(this.getSpeedAttribute());
            }
        }
        this.m_20124_(pose);
    }

    protected void updateBobing() {
        this.oBob = this.bob;
        float f = this.m_20096_() && !this.m_21224_() && !this.m_6069_() ? Math.min(0.1f, (float)this.m_20184_().m_165924_()) : 0.0f;
        this.bob += (f - this.bob) * 0.4f;
    }

    public Boolean isWalking() {
        if (!this.hasPassenger()) {
            return false;
        }
        LivingEntity entity = this.m_6688_();
        return (double)entity.f_20900_ != 0.0 || (double)entity.f_20902_ != 0.0;
    }

    public boolean hasPlayerPassenger() {
        return this.m_6688_() instanceof Player;
    }

    public Player getPlayerPassenger() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    public boolean hasPassenger() {
        return this.m_6688_() instanceof LivingEntity;
    }

    public ItemStack getPassengerItem(EquipmentSlot slot) {
        return this.hasPassenger() ? this.m_6688_().m_6844_(slot) : ItemStack.f_41583_;
    }

    public void jump() {
        this.jumpScale = 1.0f;
    }

    public void ride(LivingEntity entity) {
        entity.m_146922_(this.m_146908_());
        entity.m_146926_(this.m_146909_());
        entity.m_20329_((Entity)this);
    }

    public void exitArmor() {
        if (this.hasPassenger()) {
            this.m_6688_().m_8127_();
        }
    }

    protected boolean isPlayerFlying() {
        Player player;
        LivingEntity livingEntity = this.m_6688_();
        return livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_() && player.m_150110_().f_35935_;
    }

    private float getDamageAfterAbsorb(float damage) {
        this.updateTotalArmor();
        return CombatRules.m_19272_((float)damage, (float)this.totalDefense, (float)this.totalToughness);
    }

    private boolean isJumping() {
        return this.isJumping;
    }

    private double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    private void travelWithPassenger(Vec3 travelVector) {
        LivingEntity entity = this.m_6688_();
        if (entity == null) {
            return;
        }
        this.setRotationMatchingPassenger(entity);
        if (this.jumpScale > 0.0f && !this.isJumping() && this.m_20096_()) {
            this.jump(entity);
        }
        if (this.m_6109_()) {
            super.m_7023_(new Vec3((double)entity.f_20900_, travelVector.f_82480_, (double)entity.f_20902_));
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        if (this.m_20096_()) {
            this.jumpScale = 0.0f;
            this.isJumping = false;
        }
    }

    private void creativeFlyTravel() {
        Player player = this.getPlayerPassenger();
        this.m_20242_(true);
        this.setRotationMatchingPassenger((LivingEntity)player);
        float acceleration = 0.1f;
        float forward = player.f_20902_;
        float strafe = player.f_20900_;
        float vertical = 0.0f;
        if (player.f_20899_) {
            vertical += 1.0f;
        }
        if (player.m_6144_()) {
            vertical -= 1.0f;
        }
        Vec3 look = player.m_20154_();
        Vec3 desiredMotion = this.calculateDesiredMotion(look, forward, strafe, vertical);
        Vec3 currentMotion = this.m_20184_();
        Vec3 newMotion = this.applyAcceleration(currentMotion, desiredMotion, acceleration);
        float speedFactor = player.m_150110_().m_35947_() * 10.0f;
        if (player.m_20142_()) {
            speedFactor *= 1.2f;
        }
        newMotion = newMotion.m_82490_((double)speedFactor);
        this.m_20256_(newMotion);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.8));
        this.f_19789_ = 0.0f;
    }

    private boolean isAboveGround() {
        return this.m_20096_() || this.f_19789_ < this.m_274421_() && !this.m_9236_().m_45756_((Entity)this, this.getMove());
    }

    @NotNull
    private AABB getMove() {
        return this.m_20191_().m_82386_(0.0, (double)(this.f_19789_ - this.m_274421_()), 0.0);
    }

    private void jump(LivingEntity entity) {
        double jump = this.getCustomJump() * (double)this.jumpScale * (double)this.m_20098_();
        this.m_20334_(this.m_20184_().f_82479_, jump, this.m_20184_().f_82481_);
        this.isJumping = true;
        this.f_19812_ = true;
        if (entity.f_20902_ > 0.0f) {
            float x = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float z = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * x * this.jumpScale), 0.0, (double)(0.4f * z * this.jumpScale)));
        }
        this.jumpScale = 0.0f;
    }

    private void setRotationMatchingPassenger(LivingEntity livingEntity) {
        this.f_19859_ = this.m_146908_();
        this.m_146922_(livingEntity.m_146908_());
        this.m_146926_(livingEntity.m_146909_() * 0.5f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }
}

