/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.holders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.ntgl.client.util.IHeldAnimation;
import com.nukateam.ntgl.client.util.pose.BazookaPose;
import com.nukateam.ntgl.client.util.pose.HammerPose;
import com.nukateam.ntgl.client.util.pose.KnifePose;
import com.nukateam.ntgl.client.util.pose.MiniGunPose;
import com.nukateam.ntgl.client.util.pose.OneHandedPose;
import com.nukateam.ntgl.client.util.pose.TwoHandedPose;
import com.nukateam.ntgl.client.util.pose.VanillaPose;
import com.nukateam.ntgl.common.data.holders.ResourceHolder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;

public class GripType
extends ResourceHolder {
    public static final GripType VANILLA = new GripType(ResourceLocation.m_214293_((String)"ntgl", (String)"vanilla"), new VanillaPose(), true);
    public static final GripType ONE_HANDED = new GripType(ResourceLocation.m_214293_((String)"ntgl", (String)"one_handed"), new OneHandedPose(), true);
    public static final GripType TWO_HANDED = new GripType(ResourceLocation.m_214293_((String)"ntgl", (String)"two_handed"), new TwoHandedPose());
    public static final GripType MINI_GUN = new GripType(ResourceLocation.m_214293_((String)"ntgl", (String)"mini_gun"), new MiniGunPose());
    public static final GripType BAZOOKA = new GripType(ResourceLocation.m_214293_((String)"ntgl", (String)"bazooka"), new BazookaPose());
    public static final GripType HAMMER = new GripType(ResourceLocation.m_214293_((String)"ntgl", (String)"hammer"), new HammerPose());
    public static final GripType KNIFE = new GripType(ResourceLocation.m_214293_((String)"ntgl", (String)"knife"), new KnifePose(), true);
    private static final Map<ResourceLocation, GripType> gripTypeMap = new HashMap<ResourceLocation, GripType>();
    private final IHeldAnimation heldAnimation;
    private final boolean isOneHanded;

    public GripType(ResourceLocation id, IHeldAnimation heldAnimation) {
        this(id, heldAnimation, false);
    }

    public GripType(ResourceLocation id, IHeldAnimation heldAnimation, boolean isOneHanded) {
        super(id);
        this.heldAnimation = heldAnimation;
        this.isOneHanded = isOneHanded;
    }

    public static boolean applyBackTransforms(LivingEntity entity, PoseStack poseStack) {
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
            return false;
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (entity.m_6047_()) {
            poseStack.m_85837_(0.0, -0.4375, -0.25);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
        } else {
            poseStack.m_85837_(0.0, -0.3125, -0.125);
        }
        if (!entity.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            poseStack.m_85837_(0.0, 0.0, -0.0625);
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        return true;
    }

    public static void registerType(GripType type) {
        gripTypeMap.putIfAbsent(type.getId(), type);
    }

    public static GripType getType(ResourceLocation id) {
        return gripTypeMap.getOrDefault(id, ONE_HANDED);
    }

    public static GripType getType(String id) {
        return GripType.getType(ResourceLocation.m_135820_((String)id));
    }

    public IHeldAnimation getHeldAnimation() {
        return this.heldAnimation;
    }

    public boolean isOneHanded() {
        return this.isOneHanded;
    }

    static {
        GripType.registerType(VANILLA);
        GripType.registerType(ONE_HANDED);
        GripType.registerType(TWO_HANDED);
        GripType.registerType(MINI_GUN);
        GripType.registerType(BAZOOKA);
        GripType.registerType(HAMMER);
        GripType.registerType(KNIFE);
    }
}

