/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.container;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.event.AttachmentEvent;
import com.nukateam.ntgl.common.foundation.container.slot.AttachmentSlot;
import com.nukateam.ntgl.common.foundation.init.ModContainers;
import com.nukateam.ntgl.common.util.data.Pos2I;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AttachmentContainer
extends AbstractContainerMenu {
    public static final int SCREEN_OFFSET_Y = 132;
    public static final Pos2I INVENTORY_OFFSET = new Pos2I(18, 132);
    public static final Pos2I HOTBAR_OFFSET = new Pos2I(18, 190);
    private final ItemStack weapon;
    private final Container playerInventory;
    private final Container weaponInventory;
    private final Player player;
    private boolean loaded = false;

    public AttachmentContainer(int windowId, Inventory playerInventory, ItemStack stack) {
        this(windowId, playerInventory);
        WeaponData gunData = new WeaponData(stack, (LivingEntity)playerInventory.f_35978_);
        Set<AttachmentType> sortedAttachments = WeaponModifierHelper.getAttachmentTypes(gunData);
        ArrayList<ItemStack> attachmentItems = new ArrayList<ItemStack>();
        for (AttachmentType attachmentType : sortedAttachments) {
            attachmentItems.add(WeaponStateHelper.getAttachmentItem(attachmentType, stack));
        }
        for (int i = 0; i < attachmentItems.size(); ++i) {
            this.weaponInventory.m_6836_(i, (ItemStack)attachmentItems.get(i));
        }
        this.loaded = true;
    }

    public AttachmentContainer(int windowId, Inventory playerInventory) {
        super((MenuType)ModContainers.ATTACHMENTS.get(), windowId);
        this.weapon = playerInventory.m_36056_();
        this.playerInventory = playerInventory;
        this.player = playerInventory.f_35978_;
        WeaponData gunData = new WeaponData(this.weapon, (LivingEntity)playerInventory.f_35978_);
        Set<AttachmentType> sortedTypes = WeaponModifierHelper.getAttachmentTypes(gunData);
        this.weaponInventory = new SimpleContainer(sortedTypes.size()){

            public void m_6596_() {
                super.m_6596_();
                AttachmentContainer.this.m_6199_((Container)this);
            }
        };
        int index = 0;
        for (AttachmentType type : sortedTypes) {
            this.m_38897_(new AttachmentSlot(this, this.weaponInventory, this.weapon, type, playerInventory.f_35978_, index, 7 + index * 18 + 1, 108));
            ++index;
        }
        this.addPlayerInventory(playerInventory);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_182406_(int slotId, int stateId, ItemStack stack) {
        WeaponData gunData = new WeaponData(this.weapon, (LivingEntity)this.player);
        ItemStack oldStack = this.m_38853_(slotId).m_7993_();
        if (!MinecraftForge.EVENT_BUS.post((Event)new AttachmentEvent.SlotUpdateEvent(this, gunData, oldStack, stack))) {
            super.m_182406_(slotId, stateId, stack);
        }
    }

    public void m_6199_(Container inventoryIn) {
        ArrayList<ItemStack> attachments = new ArrayList<ItemStack>();
        MinecraftForge.EVENT_BUS.post((Event)new AttachmentEvent.ContainerUpdateEvent(this, new WeaponData(this.weapon, (LivingEntity)this.player)));
        for (int i = 0; i < this.getWeaponInventory().m_6643_(); ++i) {
            ItemStack itemStack = this.m_38853_(i).m_7993_();
            attachments.add(itemStack);
        }
        WeaponStateHelper.saveAttachments(new WeaponData(this.weapon, (LivingEntity)this.player), attachments);
        super.m_38946_();
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack copyStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        ItemStack slotStack = slot.m_7993_();
        if (!slotStack.m_41619_()) {
            copyStack = slotStack.m_41777_();
            if (index < this.weaponInventory.m_6643_() ? !this.m_38903_(slotStack, this.weaponInventory.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.weaponInventory.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return copyStack;
    }

    public Container getPlayerInventory() {
        return this.playerInventory;
    }

    public Container getWeaponInventory() {
        return this.weaponInventory;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * AttachmentContainer.INVENTORY_OFFSET.x, AttachmentContainer.INVENTORY_OFFSET.y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == playerInventory.f_35977_) {
                this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * AttachmentContainer.HOTBAR_OFFSET.x, AttachmentContainer.HOTBAR_OFFSET.y){

                    public boolean m_8010_(Player playerIn) {
                        return false;
                    }
                });
                continue;
            }
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * AttachmentContainer.HOTBAR_OFFSET.x, AttachmentContainer.HOTBAR_OFFSET.y));
        }
    }
}

