/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.nukateam.ntgl.common.network.IMessage;
import com.nukateam.ntgl.common.network.ServerPlayHandler;
import com.nukateam.ntgl.common.network.enums.HandAction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.network.NetworkEvent;

public class C2SMessageHandAction
implements IMessage<C2SMessageHandAction> {
    private InteractionHand hand = InteractionHand.MAIN_HAND;
    private HandAction handAction;

    public C2SMessageHandAction() {
    }

    public C2SMessageHandAction(InteractionHand hand, HandAction handAction) {
        this.hand = hand;
        this.handAction = handAction;
    }

    @Override
    public void encode(C2SMessageHandAction message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.hand);
        buffer.m_130068_((Enum)message.handAction);
    }

    @Override
    public C2SMessageHandAction decode(FriendlyByteBuf buffer) {
        return new C2SMessageHandAction((InteractionHand)buffer.m_130066_(InteractionHand.class), (HandAction)buffer.m_130066_(HandAction.class));
    }

    @Override
    public void handle(C2SMessageHandAction message, NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ServerPlayHandler.handleHandAction(message, player);
            }
        });
        context.setPacketHandled(true);
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public HandAction getHandAction() {
        return this.handAction;
    }
}

